<?php

namespace Shop\ValueObject;

/**
 * Description of Filter
 *
 * @author Admin
 */
class Filter {

    protected $brand_alias;
    protected $category_alias;
    protected $page;
    protected $productId;

    function __construct($page, $categoryAlias, $brandAlias, $productId) {
        $this
                ->setPage($page)
                ->setCategoryAlias($categoryAlias)
                ->setBrandAlias($brandAlias)
                ->setProductId($productId)
        ;
    }

    function getProductId() {
        return $this->productId;
    }

    function setProductId($productId) {
        $this->productId = $productId;
        return $this;
    }

    function getBrandAlias() {
        return $this->brand_alias;
    }

    function getCategoryAlias() {
        return $this->category_alias;
    }

    function getPage() {
        return $this->page;
    }

    function setBrandAlias($brand_alias) {
        $this->brand_alias = $brand_alias;
        return $this;
    }

    function setCategoryAlias($category_alias) {
        $this->category_alias = $category_alias;
        return $this;
    }

    function setPage($page) {
        $this->page = $page;
        return $this;
    }

}
