<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Util\PropelModelPager;
use Shop\Models\Manager\Map\ManagerTableMap;
use Shop\Models\Shop\Shop as ShopEntity;
use Shop\Models\Shop\ShopQuery;
use Shop\Repositories\Shop\ShopCriteria;


/**
 * Description of Shop
 *
 * @author Admin
 */
class Shop extends PropelQueryAbstract implements CrudInterface,
    \Core\Repository\DropdownInreface,
    \Shop\Contracts\ShopCurrentInterface
{

    use \Shop\Concrete\ShopAuthUserTrait;

    public function buildQuery()
    {

        $id = $this->curShop ? $this->curShop->getId() : 0;

        return ShopQuery::create()
            ->_if($id > 0)
            ->filterById($id)
            ->_or()
            ->filterByParentId($id)
            ->_endif();
    }

    public function buildEntity()
    {
        return new ShopEntity;
    }


    /**
     * Основной метод на выборку
     * @param ShopCriteria $criteria
     * @return PropelModelPager
     */
    public function findByCriteria(ShopCriteria $criteria):PropelModelPager{

        return $this->buildQuery()
            ->_if($criteria->getFilterByParentId()!==null)
            ->filterByParentId($criteria->getFilterByParentId())
            ->_endif()
            ->_if($criteria->getFilterByType()!==null)
            ->filterByType($criteria->getFilterByType())
            ->_endif()

            ->paginate($criteria->getPage(), $criteria->getRowsLimit())
        ;
    }


    /**
     * Получение главного магазина
     * @return ObjectCollection
     */
    public function findOneMain()
    {

        $res = $this->buildQuery()
            ->filterByType("main")
            ->useManagerQuery()
            ->endUse()
        ;
        //$q = $res->toString();
        return $res->findOne();
    }

    /**
     * Получение дилеров
     * @return ObjectCollection
     */
    public function findDealers(): ObjectCollection
    {
        return $this->buildQuery()
            ->filterByType("dealer")
            ->useManagerQuery()
            ->endUse()
            ->find()
            ;
    }

    /**
     * поиск как дилеров так и ГО
     * @return ObjectCollection
     */
    public function findMainAndDealers($shopKeys = []): ObjectCollection
    {
        return $this->buildQuery()
            ->_if(count($shopKeys))
            ->filterByPrimaryKeys($shopKeys)
            ->_endif()
            ->useAddressQuery()
            ->useCityQuery()
            ->orderByName()
            ->endUse()
            ->endUse()
            ->filterByActive('Y')
            ->findByType(["dealer", "main"]);
    }

    /**
     *
     * @param type $id
     * @return ObjectCollection
     */
    public function findStocksByMainId($id): ObjectCollection
    {
        return $this->buildQuery()
            ->filterByType("stock")
            ->filterByParentId($id)
            ->filterByActive('Y')
            //->useParentShopQuery()
            //   ->filterByType("main")
            //->endUse()
            ->find();
    }

    /**
     *
     * @return array
     */
    public function getDropdownList(): array
    {
        return $this->buildQuery()
            ->orderByTitle()
            ->find()
            ->toKeyValue('id', 'title');
    }

    /**
     *
     * @return array
     */
    public function getDropdownListWithManagers(): array
    {
        return $this->buildQuery()
            ->orderByTitle()
            ->useManagerQuery()
            ->enduse()
            ->find()
            ->toKeyValue('id', 'title');
    }

    /**
     *
     * @param type $id
     * @return \Shop\Models\Shop\Shop
     */
    public function findById($id)
    {
        return $this->buildQuery()->findPk($id);
    }
}
