<?php
namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\DropdownInreface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Manager\ManagerQuery;
use Shop\Models\Manager\Manager as ManagerEntity;
/**
 * Description of Brand
 *
 * @author Dmitriy
 */
class Manager extends PropelQueryAbstract implements CrudInterface, DropdownInreface,
         \Shop\Contracts\ShopCurrentInterface{

    use \Shop\Concrete\ShopAuthUserTrait;
    
    /**
     * 
     * @return ManagerEntity
     */
    public function buildEntity():ManagerEntity{
	return new ManagerEntity;
    }

    /**
     * 
     * @return ManagerQuery
     */
    public function buildQuery():ManagerQuery{
	return ManagerQuery::create()
                ->_if($this->curShop)
                    ->filterByShop($this->curShop)
                ->_endif();;
    }
    
    public function getDropdownList(){
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }

    public function getDropdownListWithShop(){
	return $this->getQuery()
		->orderByName()
                ->useShopQuery()
                ->endUse()
                ->withColumn("CONCAT(`shop_managers`.name,' (',`shop_shops`.title,')')","fullename")
		->find()
		->toKeyValue('id','fullename');
    }
    

    /**
     * 
     * @param type $id
     * @return ManagerEntity
     */
    public function findFirstManagerByShopId($id): ManagerEntity
    {
        return $this->buildQuery()
		->orderByName()
		->findOneByShopId($id)
                ;
    }
}
