<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Discount\DiscountQuery;
use Shop\Models\Discount\Discount as DiscountEntity;

/**
 * Description of Discount
 *
 * @author Admin
 */
class Discount extends PropelQueryAbstract implements CrudInterface
{

    public function buildEntity()
    {
        return new DiscountEntity;
    }

    public function buildQuery()
    {
        return DiscountQuery::create();
    }

    /**
     * 
     * @param type $summ
     * @return type
     */    
    public function getNextDiscount($summ)
    {
        return $this
                ->buildQuery()
                ->filterByPriceFrom($summ, \Propel\Runtime\ActiveQuery\Criteria::GREATER_THAN)
                ->orderByPriceFrom(\Propel\Runtime\ActiveQuery\Criteria::ASC)
                ->orderByPercent(\Propel\Runtime\ActiveQuery\Criteria::DESC)
                ->findOne();
    }

    /**
     * получение скидки которая входит в диапазон
     * @param type $summ
     * @return type
     */
    public function getDiscount($summ)
    {
        return $this
                ->buildQuery()
                ->filterByPriceFrom($summ, \Propel\Runtime\ActiveQuery\Criteria::LESS_EQUAL)
                ->filterByPriceTo($summ, \Propel\Runtime\ActiveQuery\Criteria::GREATER_THAN)
                ->orderByPercent(\Propel\Runtime\ActiveQuery\Criteria::DESC)
                ->findOne();
    }    

}