<?

namespace Shop\Repositories\Brand;

use Shop\Repositories\AbstractCriteria;

/**
 * Description of ProductCriteria
 *
 * @author Admin
 */
class BrandCriteria extends  AbstractCriteria
{

    /**
     * @var int|null
     */
    protected $filterByProductCategoryId;

    /**
     * @var string|null
     */
    protected $filterByAlias;

    /**
     * @var array|null
     */
    protected $filterByPriceListScheetIds;

    /**
     * @var string|null
     */
    protected $sortByName;

    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return BrandCriteria
     */
    public function setSortByName(?string $sortByName): BrandCriteria
    {
        $this->sortByName = $sortByName;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByPriceListScheetIds(): ?array
    {
        return $this->filterByPriceListScheetIds;
    }

    /**
     * @param array|null $filterByPriceListScheetIds
     * @return BrandCriteria
     */
    public function setFilterByPriceListScheetIds(?array $filterByPriceListScheetIds): BrandCriteria
    {
        $this->filterByPriceListScheetIds = $filterByPriceListScheetIds;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByAlias(): ?string
    {
        return $this->filterByAlias;
    }

    /**
     * @param string|null $filterByAlias
     * @return BrandCriteria
     */
    public function setFilterByAlias(?string $filterByAlias): BrandCriteria
    {
        $this->filterByAlias = $filterByAlias;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterByProductCategoryId(): ?int
    {
        return $this->filterByProductCategoryId;
    }

    /**
     * @param int|null $filterByProductCategoryInt
     * @return BrandCriteria
     */
    public function setFilterByProductCategoryInt(?int $filterByProductCategoryInt): BrandCriteria
    {
        $this->filterByProductCategoryId = $filterByProductCategoryInt;
        return $this;
    }


    /**
     * @return mixed|BrandCriteria
     */
    public static function create()
    {
        return new self;
    }


}