<?

namespace Shop\Modules\AdminSettingsPaymaster;

use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Shop\Config\Sms;

/**
* Description of AdminSettingsPaymaster
*
* @author Diamond Code Generator
*/
class AdminSettingsPaymaster extends \Core\ModuleController{

    protected $formBuilder;
    protected $controlBuilder;
    protected $conf;
    protected $confMain;

    function __construct(FormBuilder $form, ControlBuilder $controlBuilder, \Shop\Config\Payment $conf, \Shop\Config\Main $confMain
    )
    {
        $this->formBuilder = $form;
        $this->controlBuilder = $controlBuilder;
        $this->conf = $conf;
        $this->confMain = $confMain;
    }
    
    public function process() {
        
        $form = $this->formBuilder->buildSettingsForm($this->conf, "paymaster");
        $builder = $this->controlBuilder;
        
        $form
                
                ->addField(
                        $builder->buildInputSmall("merchantId"), "Идентификатор клиента в сервисе","required","Merchant Id"
                )
                ->addField(
                        $builder->buildInputSmall("login"), "Логин","required"
                )
                ->addField(
                        $builder->buildInputPassword("password"), "Пароль","required"
                )
                ->addField(
                        $builder->buildDropdownYNUniform("emulateMode"), "Режим эмуляции оплаты", "required","Сразу переход на страницу Success URL"
                )
                ->addField(
                        $builder->buildInputLittle("commission"), "Коммиссия платежной системы, %"
                )
                ;
                
        return $form->render();
    }

}               