<?

namespace Shop\Helpers;

/**
 * Функции форматирования колонок таблиц и полей форм
 *
 * @author Admin
 */
class Formatter
{
    /**
     * 
     * @param \Shop\Models\Order\Order $order
     */
    public static function linkOrderCode(\Shop\Models\Order\Order $order = null):string{
        return !$order ? "" : anchor("/admin/shop/orders",$order->getOrderCode(),[], [
            "id"    => $order->getId()
        ]);
    }
    
    /**
     * 
     * @param \Shop\Models\State\State $state
     * @return string
     */
    public static function formatColor(\Shop\Models\State\State $state): string
    {
        return sprintf('<font style="color:%s">%s</font>', $state->getColor() ?: "#000" , $state->getTitle());
    }
}