<?

namespace Shop\DTO;

/**
 * Description of CatalogFilter
 *
 * @author Admin
 */
class CatalogFilter implements \Shop\Contracts\CatalogFilterInterface
{

    protected $brands = [];
    protected $categoryId = null;
    protected $shopId;
    protected $groups = [];
    protected $sizeType;
    protected $sizeValues = [];
    protected $priceMax = 0;
    protected $priceMin = 0;
    protected $productName;
    protected $brandName;
    protected $sale = false;
    protected $new = 0;
    protected $products = [];
    protected $priceListScheetIds = [];
    protected $article;
    protected $customer;
    protected $brandMain;
    protected $parentCategoryId;
    protected $imgExit = true;
    protected $parentCategories = [];

    public function getParentCategories(): array
    {
       return $this->parentCategories;
    }

    /**
     * @param array $parentCategories
     * @return CatalogFilter
     */
    public function setParentCategories(array $parentCategories): CatalogFilter
    {
        $this->parentCategories = $parentCategories;
        return $this;
    }
    

    function getImgExit():bool
    {
        return $this->imgExit;
    }

    function setImgExit(bool $imgExit)
    {
        $this->imgExit = $imgExit;
        return $this;
    }

        
    public function getBrandMain()
    {
        return $this->brandMain;
    }

    public function getParentCategoryId()
    {
        return $this->parentCategoryId;
    }

    function getCustomer()
    {
        return $this->customer;
    }

    function setCustomer(\Shop\Contracts\CustomerComplexInterface $customer)
    {
        $this->customer = $customer;
        return $this;
    }    
    
    function getArticle()
    {
        return $this->article;
    }

    function setPriceListScheetIds(array $ids){
        $this->priceListScheetIds = $ids;
        return $this;
    }
    /**
     * 
     * @return array
     */
    function getPriceListScheetIds(): array
    {
        return $this->priceListScheetIds;
    }

    public function getProducts(): array
    {
        return $this->products;
    }

    function setProducts($products)
    {
        $this->products = $products;
        return $this;
    }

    function getNew(): int
    {
        return $this->new;
    }

    function setNew(int $new)
    {
        $this->new = $new;
        return $this;
    }

    function getSale(): int
    {
        return $this->sale;
    }

    function setSale(int $sale)
    {
        $this->sale = $sale;
        return $this;
    }

    function getBrandName()
    {
        return $this->brandName;
    }

    function setBrandName($brandName)
    {
        $this->brandName = $brandName;
        return $this;
    }

    function getName()
    {
        return $this->name;
    }

    function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    function getSizeValues(): array
    {
        return $this->sizeValues;
    }

    function setSizeValues($sizeValues)
    {
        $this->sizeValues = $sizeValues;
        return $this;
    }

    function getBrands(): array
    {
        return $this->brands;
    }

    function setBrands($brands)
    {
        $this->brands = $brands;
        return $this;
    }

    function getCategoryId()
    {
        return $this->categoryId;
    }

    function getShopId(): int
    {
        return $this->shopId;
    }

    function setCategoryId($categoryId)
    {
        $this->categoryId = $categoryId;
        return $this;
    }

    function setShopId($shopId)
    {
        $this->shopId = $shopId;
        return $this;
    }

    function getGroups(): array
    {
        return $this->groups;
    }

    function setGroups($groups)
    {
        $this->groups = $groups;
        return $this;
    }

    function getSizeType()
    {
        return $this->sizeType;
    }

    function setSizeType($sizeType)
    {
        $this->sizeType = $sizeType;
        return $this;
    }

    function getPriceMax(): int
    {
        return $this->priceMax;
    }

    function getPriceMin(): int
    {
        return $this->priceMin;
    }

    function setPriceMax($priceMax)
    {
        $this->priceMax = $priceMax;
        return $this;
    }

    function setPriceMin($priceMin)
    {
        $this->priceMin = $priceMin;
        return $this;
    }

    public function getProductName()
    {
        return $this->productName;
    }

    public function setProductName($name)
    {
        $this->productName = $name;
        return $this;
    }

}