<?

namespace Shop\Services;

/**
 * Description of Analitic
 *
 * @author Admin
 */
class Analitic implements \Core\TwigAwareInterface
{
    protected $twig;
    
    protected $template;
    
    protected $positionRepo;
    
    use \Core\TwigAwareTrait;
    
    function __construct( 
            \Core\Template\Template $template,
            \Shop\Repositories\Position $position
            )
    {
        $this->template = $template;
        $this->positionRepo = $position;
    }

    /**
     * Добавляет информацию о заказе в гугл аналитику
     * @param \Shop\Models\Order\Order $order
     */
    public function addTransaction(\Shop\Models\Order\Order $order): bool
    {
        
        $analitic = new \Widgets\Google\AnaliticTransaction\AnaliticTransaction($this->template,$this->twig);
        
        foreach($order->getOrderItems() as $item){
            
            $position = $this->positionRepo->findByRefId($item->getRefId());
            
            if($position){
                $catName = $position->getProduct()->getCategory()->getNameWithParent();
            }
            else{
                $catName = "без категории";
            }
            
            $analitic->addItem(
                        $order->getId(),
			$item->getName(),
			$item->getArticle(),
                        $item->getBrand(),
			$catName,
			$item->getPrice(),
			$item->getDesc(),
                        $item->getAmount()
                    );
        }
        
        $analitic->setTransaction(
		$order->getId(),
		$order->getShop()->getTitleWithType(),
		$order->getSumm(),
		0,//доставка
		0//налог
		);
        
        //в шаблон js скрипт
        $analitic->Render();
        
        return true;
    }

}