<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\Collection\ObjectCollection;
use Shop\Models\State\State as StateEntity;
use Shop\Models\State\StateQuery;


/**
 * Description of State
 *
 * @author Admin
 */
class State extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropdownInreface{

    public function buildQuery(){
	return StateQuery ::create();
    }

    public function buildEntity(){
	return new StateEntity;
    }
    
    /**
     * получение списка
     * @return type
     */
    public function getDropdownList(){
	return $this->buildQuery()
		->orderByTitle()
		->find()
		->toKeyValue('id', 'title');
    }    
   
}
