<?php
namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\DropdownInreface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Region\RegionQuery;
use Shop\Models\Region\Region as RegionEntity;
/**
 * Description of Brand
 *
 * @author Dmitriy
 */
class Region extends PropelQueryAbstract implements CrudInterface, DropdownInreface{

    public function buildEntity(){
	return new RegionEntity;
    }

    public function buildQuery(){
	return RegionQuery::create();
    }
    
    public function getDropdownList(){
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }
    
    /**
     * 
     */
    public function getDropdownListByCountry($id){
        return $this->buildQuery()
                ->findByCountryId($id)
                ->toKeyValue('id','name');
    }
    
}
