<?php


namespace Shop\Repositories;


abstract class AbstractCriteria
{
    /**
     * @var int|null
     */
    protected $rowsLimit;


    /**
     * @var int|null
     */
    protected $page;

    /**
     *
     * @var int|null
     */
    protected $filterById;

    /**
     * @var array|null
     */
    protected $filterByIds;

    /**
     * @return array|null
     */
    public function getFilterByIds(): ?array
    {
        return $this->filterByIds;
    }

    /**
     * @param array|null $filterByIds
     * @return AbstractCriteria
     */
    public function setFilterByIds(?array $filterByIds): AbstractCriteria
    {
        $this->filterByIds = $filterByIds;
        return $this;
    }


    public function getPage()
    {

        return $this->page;
    }

    public function setPage($filter)
    {

        $this->page = $filter;

        return $this;
    }

    function getFilterById()
    {
        return $this->filterById;
    }

    function setFilterById($filterById)
    {
        $this->filterById = $filterById;
        return $this;
    }

    public function getRowsLimit()
    {

        return $this->rowsLimit;
    }

    public function setRowsLimit($filter)
    {

        $this->rowsLimit = $filter;

        return $this;
    }

    /**
     * @return mixed
     */
    public static abstract function create();
}