<?

namespace Shop\Modules\LastClientsWidget;

/**
* Description of LastClientsWidget
*
* @author Diamond Code Generator
*/
class LastClientsWidget extends \Core\ModuleController{

    public $limit = 3;
    
    protected $customerRepo;
    protected $mainConf;
            
    function __construct(
            \Shop\Repositories\Customer $customerRepo, 
            \Shop\Config\Main $mainConf
            )
    {
        $this->customerRepo = $customerRepo;
        $this->mainConf = $mainConf;
    }


    public function process() {

        $clients = $this
                ->customerRepo
                ->findLastByLimit($this->limit, [$this->mainConf->getDefaultGuestGroup()]);
        
        return $this->render([
            "clients"   =>  $clients
        ]);
    }

}               