<?

namespace Shop\Modules\DealerMaster;

/**
 * Description of DealerMaster
 *
 * @author Diamond Code Generator
 */
class DealerMaster extends \Core\ModuleController
{
    protected $template;
    protected $countryRepo;
    protected $cBuilder;
    protected $regionRepo;
    protected $cityRepo;
    protected $shopService;
            
    function __construct(\Core\Template\Template $template,
                         \Shop\Repositories\Country $countryRepo,
                         \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\Region $regionRepo,
                         \Shop\Repositories\City $cityRepo,
                         \Shop\Services\Shop $shopService
            )
    {
        $this->template     = $template;
        $this->countryRepo  = $countryRepo;
        $this->cBuilder     = $cBuilder;
        $this->regionRepo   = $regionRepo;
        $this->cityRepo     = $cityRepo;
        $this->shopService  = $shopService;
    }
    
    public function process()
    {
      
        
        if(input_post("domain_name")){
            $dealerComplex = (new \Shop\DTO\DealerComplex())
                    ->setDomainName(input_post("domain_name"))
                    ->setDomainLang(input_post("domain_lang"))
                    ->setDomainDomain(input_post("domain_domain"))
                    ->setStockCityId(input_post("stock_city_id"))
                    ->setStockName(input_post("stock_name"))
                    ->setStockStreet(input_post("stock_street"))
                    ->setStockRoom(input_post("stock_room"))
                    ->setStockHouse(input_post("stock_house"))
                    ->setUserName(input_post("user_name"))
                    ->setUserEmail(input_post("user_email"))
                    ->setUserPassword(input_post("stock_password"))
                    ->setCopyPages(input_post("copy_pages")=="on")
                    ->setCopyMenu(false)
                    ->setCopyPromoblocks(input_post("copy_promoblocks")=="on")
                    ->setCopyContents(input_post("copy_contents")=="on")
                    ->setCopyTemplates(input_post("copy_templates")=="on")
                    ;
            try{
                $this->shopService->createDealerComplex($dealerComplex);
                return $this->render("success");
            } catch (\Shop\Exceptions\UserGroupNotFoundException $ex) {
                return $this->render("false");
            }
            
            
            
        }        

        
        $this->template->addScriptLinks(array(
            '{js_path}jquery/wizard/smartWizard-2.0.min.js',
            '{js_path}jquery/form/jquery.form.min.js',
        ));
        $this->template->addScript($this->render("javascript"));
     
        $countries = \Diamond\Helpers\Form::prepareDropdown($this->countryRepo);
        
        $cities     = [null => 'город не выбран'];
        $regions    = [null => 'регион не выбран'];  
        
        $regionId = $cityId = $countryId = null;
        
        if(input_post("countryId")>0){
            $regions = $this->regionRepo->getDropdownListByCountry(input_post("countryId"));
        }
        
        
        if(input_post("regionId")>0){
            $cities = $this->cityRepo->getDropdownListByregion(input_post("regionId"));
        }

        
        
        
        
        $countryField 
                = $this
                ->cBuilder
                ->buildDropdownUniform('countryId', $countries )
                ->onChange("select_region(this,'regionId')")
                ->setId("countryId")
                ;
     
        $regionField 
                = $this
                ->cBuilder
                ->buildDropdownUniform('regionId', $regions)
                ->onChange("select_city(this,'stock_city_id')")
                ->setId("regionId")
                ;
        
        $cityField 
                = $this
                ->cBuilder
                ->buildDropdownUniform('stock_city_id', $cities)
                ->setId("stock_city_id")
                ;
        
        return $this->render([
                    "selected"  =>  1,
                    "steps" => [
                        [
                            "id"    => 1,
                            "title" => "Шаг 1",
                            "desc"  => "Настройка домена",
                            "content"   =>  $this->render("step1")
                        ],
                        [
                            "id"    => 2,
                            "title" => "Шаг 2",
                            "desc"  => "Создание офиса дилера",
                            "content"   =>  $this->render("step2",[
                                "countryField"  =>  $countryField->render(),
                                "regionField"   =>  $regionField->render(),
                                "cityField"     =>  $cityField->render()
                            ])
                        ],
                        [
                            "id"    => 3,
                            "title" => "Шаг 3",
                            "desc"  => "Настройка доступа к админ. части",
                            "content"   =>  $this->render("step3")
                        ],
                        [
                            "id"    => 4,
                            "title" => "Шаг 4",
                            "desc"  => "Копирование элементов управления",
                            "content"   =>  $this->render("step4")
                        ]
                    ]
        ]);
    }

}