<?

namespace Shop\Modules\AdminStateLogs;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminStateLogs
 *
 * @author Diamond Code Generator
 */
class AdminStateLogs extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $orderRepo;
    protected $stateRepo;
            
    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\StateLog $repo, \Shop\Repositories\Order $orderRepo, \Shop\Repositories\State $stateRepo)
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->orderRepo = $orderRepo;
        $this->stateRepo = $stateRepo;
    }

    public function process()
    {
        $table = $this->tableFactory->buildAdminTable("states", $this->repo->setSelectFilter([$this,"sortedById"]));

        $table
                ->removeControl("button_add")
                ->removeControl("button_del")
                ->removeControl("button_edit")
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn((new Column("datetime", "Дата", 80))->setFn([$this, "formatDate"]))
                ->addColumn((new Column("oldStateId", "Старое состояние", 80))->setFn([$this, "formatStateOld"]))
                ->addColumn((new Column("newStateId", "Новое состояние", 80))->setFn([$this, "formatStateNew"]))
                ->addColumn((new Column("objectId", "№ заказа", 80))->setFn([$this, "formatCode"]))
        ;

        return $table->render();
    }
    
    /**
     * 
     * @param \Shop\Models\PaymentTransaction\PaymentTransactionQuery $query
     * @return type
     */
    public function sortedById(\Shop\Models\StateLog\StateLogQuery $query) {
        return $query->orderById(\Propel\Runtime\ActiveQuery\Criteria::DESC);
    }    

    /**
     * 
     * @param \Shop\Models\PaymentTransaction\PaymentTransaction $trans
     * @return type
     */
    public function formatDate(\Shop\Models\StateLog\StateLog $log): string
    {
        return $log->getDatetime()->format(\Diamond\Helpers\Date::formatDisplay());
    }
    
    /**
     * 
     * @param \Shop\Models\StateLog\StateLog $log
     * @return type
     */
    public function formatCode(\Shop\Models\StateLog\StateLog $log)
    {
        if($log->getTypeId()==1 && $log->getObjectId() > 0){
            $order = $this->orderRepo->findById($log->getObjectId());
            return \Shop\Helpers\Formatter::linkOrderCode($order);
        }
    }
    
    /**
     * 
     * @param \Shop\Models\StateLog\StateLog $log
     */
    public function formatStateOld(\Shop\Models\StateLog\StateLog $log)
    {
        if($log->getTypeId()==1 && $log->getOldStateId()){
            return \Shop\Helpers\Formatter::formatColor($this->stateRepo->findById($log->getOldStateId()));
        }
    }

    /**
     * 
     * @param \Shop\Models\StateLog\StateLog $log
     */
    public function formatStateNew(\Shop\Models\StateLog\StateLog $log)
    {
        if($log->getTypeId()==1 && $log->getNewStateId()){
            return \Shop\Helpers\Formatter::formatColor($this->stateRepo->findById($log->getNewStateId()));
        }
    }    
}