<?

namespace Shop\Modules\AdminPaymasterTrans;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminPaymasterTrans
 *
 * @author Diamond Code Generator
 */
class AdminPaymasterTrans extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $mainConf;

    function __construct(
    \Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
    \Shop\Repositories\PaymasterTransaction $repo, \Shop\Config\Main $mainConf
    )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->mainConf = $mainConf;
    }

    public function process()
    {
        
        $table = $this->tableFactory->buildAdminTable("groups",$this->repo->setSelectFilter([$this,"sortedById"]));

        $table
                ->removeControl("button_add")
                ->removeControl("button_del")
                ->removeControl("button_edit")
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn((new Column("datetime", "Дата создания", 90))->setFn([$this, "formatDate"]))
                ->addColumn((new Column("orderCode", "Заказ", 60))->setFn([$this, "formatCode"]))
                ->addColumn(new Column("orderSumm", "Сумма заказа",70))
                ->addColumn(new Column("payedSumm", "Сумма оплаты",70))
                ->addColumn(new Column("result", "Результат",60))
                ->addColumn(new Column("commission", "Комиссия,%",60))
                ->addColumn(new Column("currency", "Валюта",40))
                ->addColumn(new Column("desc", "Комментарий",120))
                ->addColumn((new Column("confirmed", "Подтверждена",70))->setFn([$this, "formatConfirm"]))

        ;

        return $table->render();
    }

    /**
     * 
     * @param \Shop\Models\PaymentTransaction\PaymentTransactionQuery $query
     * @return type
     */
    public function sortedById(\Shop\Models\PaymentTransaction\PaymentTransactionQuery $query) {
        return $query->orderById(\Propel\Runtime\ActiveQuery\Criteria::DESC);
    }
    
    /**
     * 
     * @param \Shop\Models\PaymentTransaction\PaymentTransaction $trans
     * @return type
     */
    public function formatDate(\Shop\Models\PaymentTransaction\PaymentTransaction $trans):string
    {
        return $trans->getDatetime()->format(\Diamond\Helpers\Date::formatDisplay());
    }

    /**
     * 
     * @param \Shop\Models\CustomerGroup\CustomerGroup $group
     * @return string
     */
    public function formatCode(\Shop\Models\PaymentTransaction\PaymentTransaction $trans):string
    {
        return \Shop\Helpers\Formatter::linkOrderCode($trans->getOrder());
    }

    public function formatConfirm(\Shop\Models\PaymentTransaction\PaymentTransaction $trans):string
    {
        return \Diamond\Helpers\Formatter::formatYN($trans->getConfirmed());
    }
}