<?

namespace Shop\Modules\AdminDiscounts;

use Core\Registry\Column;
use Core\Registry\Field;
/**
* Description of AdminDiscounts
*
* @author Diamond Code Generator
*/
class AdminDiscounts extends \Core\ModuleController{

    protected $tableFactory;
    protected $repo;
    protected $cBuilder;
    protected $confMain;
            
    function __construct(\Diamond\Factory\Table $tableFactory, 
            \Shop\Repositories\Discount $discountRepo, \Core\Form\ControlBuilder $cBuilder,
            \Shop\Config\Main $confMain
            )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $discountRepo;
        $this->cBuilder = $cBuilder;
        $this->confMain = $confMain;
    }


    public function process() {
        
        $table = $this->tableFactory->buildAdminTable("discounts", $this->repo);
        $cur = $this->confMain->getCurencyDisplay();
        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("priceFrom", "Сумма от," . $cur, 120))
                ->addColumn(new Column("priceTo", "Сумма до,".$cur, 120))
                ->addColumn(new Column("percent", "Скидка,%", 120))
                ;
        
        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputLittle("priceFrom"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputLittle("priceTo"), null, "required","Включительно"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputLittle("percent"), null, "required"
                ))
        ;        
        
        return $table->render();
    }

}               