<?

namespace Shop\Modules\AdminCurriencies;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminCurriencies
 *
 * @author Diamond Code Generator
 */
class AdminCurriencies extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;

    function __construct(\Shop\Repositories\Currency $repo, \Diamond\Factory\Table $tableFactory,
                         \Core\Form\ControlBuilder $cBuilder)
    {
        $this->repo         = $repo;
        $this->tableFactory = $tableFactory;
        $this->cBuilder     = $cBuilder;
    }

    public function process()
    {

        $table = $this->tableFactory->buildAdminTable("curriency", $this->repo);

        $table
                ->addColumn(
                        new Column("id", "№", 20, false, true)
                )
                ->addColumn(
                        new Column("name", "Наименование", 120)
                )
                ->addColumn(
                        new Column("native", "Валюта сайта", 60)
                )
                ->addColumn(
                        new Column("htmlSign", "Отображение на сайте", 100)
                )
                ->addColumn(
                        new Column("displayed", "Показывать", 100)
                )
                ->addColumn(
                        new Column("iso", "Буквенный код", 80)
                )
                ->addColumn(
                        new Column("roundMode", "Режим округления", 80)
                )
                ->addColumn(
                        new Column("roundPrice", "Точность округления", 80)
                )
        ;

        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("name"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("native", [ "N" => "Нет","Y" => "Да"]), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("htmlSign"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("displayed", ["Y" => "Да", "N" => "Нет"]), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputLittle("iso"), null, "required","ISO"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputLittle("roundPrice"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("roundMode", ["ceil" => "в большую", "round" => "в меньшую"]), null, "required"
                ))
        ;

        return $table->render();
    }

}