<?php

namespace Shop\Models\Shop\Base;

use \Exception;
use \PDO;
use Diamond\Models\Domain\Domain;
use Diamond\Models\Domain\DomainQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Shop\Models\Address\Address;
use Shop\Models\Address\AddressQuery;
use Shop\Models\Manager\Manager;
use Shop\Models\Manager\ManagerQuery;
use Shop\Models\Manager\Base\Manager as BaseManager;
use Shop\Models\Manager\Map\ManagerTableMap;
use Shop\Models\Order\Order;
use Shop\Models\Order\OrderQuery;
use Shop\Models\Order\Base\Order as BaseOrder;
use Shop\Models\Order\Map\OrderTableMap;
use Shop\Models\Provider\Provider;
use Shop\Models\Provider\ProviderQuery;
use Shop\Models\Provider\Base\Provider as BaseProvider;
use Shop\Models\Provider\Map\ProviderTableMap;
use Shop\Models\Shop\Shop as ChildShop;
use Shop\Models\Shop\ShopQuery as ChildShopQuery;
use Shop\Models\Shop\ShopShopsArchive as ChildShopShopsArchive;
use Shop\Models\Shop\ShopShopsArchiveQuery as ChildShopShopsArchiveQuery;
use Shop\Models\Shop\Map\ShopTableMap;

/**
 * Base class that represents a row from the 'shop_shops' table.
 *
 *
 *
 * @package    propel.generator.Models.Shop.Base
 */
abstract class Shop implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Shop\\Models\\Shop\\Map\\ShopTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     *
     * @var        string
     */
    protected $title;

    /**
     * The value for the desc field.
     *
     * @var        string
     */
    protected $desc;

    /**
     * The value for the image field.
     *
     * @var        string
     */
    protected $image;

    /**
     * The value for the logo field.
     *
     * @var        string
     */
    protected $logo;

    /**
     * The value for the director_contact field.
     *
     * @var        string
     */
    protected $director_contact;

    /**
     * The value for the phones field.
     *
     * @var        string
     */
    protected $phones;

    /**
     * The value for the emails field.
     *
     * @var        string
     */
    protected $emails;

    /**
     * The value for the type field.
     *
     * Note: this column has a database default value of: 'main'
     * @var        string
     */
    protected $type;

    /**
     * The value for the parent_id field.
     *
     * @var        int
     */
    protected $parent_id;

    /**
     * The value for the domain_id field.
     *
     * @var        int
     */
    protected $domain_id;

    /**
     * The value for the active field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $active;

    /**
     * @var        ChildShop
     */
    protected $aParentShop;

    /**
     * @var        Domain
     */
    protected $aDomain;

    /**
     * @var        ObjectCollection|ChildShop[] Collection to store aggregation of ChildShop objects.
     */
    protected $collShopsRelatedById;
    protected $collShopsRelatedByIdPartial;

    /**
     * @var        ObjectCollection|Manager[] Collection to store aggregation of Manager objects.
     */
    protected $collManagers;
    protected $collManagersPartial;

    /**
     * @var        ObjectCollection|Order[] Collection to store aggregation of Order objects.
     */
    protected $collOrders;
    protected $collOrdersPartial;

    /**
     * @var        ObjectCollection|Provider[] Collection to store aggregation of Provider objects.
     */
    protected $collProviders;
    protected $collProvidersPartial;

    /**
     * @var        Address one-to-one related Address object
     */
    protected $singleAddress;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    // archivable behavior
    protected $archiveOnDelete = true;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ChildShop[]
     */
    protected $shopsRelatedByIdScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Manager[]
     */
    protected $managersScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Order[]
     */
    protected $ordersScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Provider[]
     */
    protected $providersScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->type = 'main';
        $this->active = 'Y';
    }

    /**
     * Initializes internal state of Shop\Models\Shop\Base\Shop object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>Shop</code> instance.  If
     * <code>obj</code> is an instance of <code>Shop</code>, delegates to
     * <code>equals(Shop)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|Shop The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [desc] column value.
     *
     * @return string
     */
    public function getDesc()
    {
        return $this->desc;
    }

    /**
     * Get the [image] column value.
     *
     * @return string
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Get the [logo] column value.
     *
     * @return string
     */
    public function getLogo()
    {
        return $this->logo;
    }

    /**
     * Get the [director_contact] column value.
     *
     * @return string
     */
    public function getdirectorContact()
    {
        return $this->director_contact;
    }

    /**
     * Get the [phones] column value.
     *
     * @return string
     */
    public function getPhones()
    {
        return $this->phones;
    }

    /**
     * Get the [emails] column value.
     *
     * @return string
     */
    public function getemails()
    {
        return $this->emails;
    }

    /**
     * Get the [type] column value.
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the [parent_id] column value.
     *
     * @return int
     */
    public function getParentId()
    {
        return $this->parent_id;
    }

    /**
     * Get the [domain_id] column value.
     *
     * @return int
     */
    public function getDomainId()
    {
        return $this->domain_id;
    }

    /**
     * Get the [active] column value.
     *
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[ShopTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Set the value of [title] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[ShopTableMap::COL_TITLE] = true;
        }

        return $this;
    } // setTitle()

    /**
     * Set the value of [desc] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setDesc($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->desc !== $v) {
            $this->desc = $v;
            $this->modifiedColumns[ShopTableMap::COL_DESC] = true;
        }

        return $this;
    } // setDesc()

    /**
     * Set the value of [image] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setImage($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->image !== $v) {
            $this->image = $v;
            $this->modifiedColumns[ShopTableMap::COL_IMAGE] = true;
        }

        return $this;
    } // setImage()

    /**
     * Set the value of [logo] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setLogo($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->logo !== $v) {
            $this->logo = $v;
            $this->modifiedColumns[ShopTableMap::COL_LOGO] = true;
        }

        return $this;
    } // setLogo()

    /**
     * Set the value of [director_contact] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setdirectorContact($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->director_contact !== $v) {
            $this->director_contact = $v;
            $this->modifiedColumns[ShopTableMap::COL_DIRECTOR_CONTACT] = true;
        }

        return $this;
    } // setdirectorContact()

    /**
     * Set the value of [phones] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setPhones($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->phones !== $v) {
            $this->phones = $v;
            $this->modifiedColumns[ShopTableMap::COL_PHONES] = true;
        }

        return $this;
    } // setPhones()

    /**
     * Set the value of [emails] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setemails($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->emails !== $v) {
            $this->emails = $v;
            $this->modifiedColumns[ShopTableMap::COL_EMAILS] = true;
        }

        return $this;
    } // setemails()

    /**
     * Set the value of [type] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setType($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->type !== $v) {
            $this->type = $v;
            $this->modifiedColumns[ShopTableMap::COL_TYPE] = true;
        }

        return $this;
    } // setType()

    /**
     * Set the value of [parent_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setParentId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->parent_id !== $v) {
            $this->parent_id = $v;
            $this->modifiedColumns[ShopTableMap::COL_PARENT_ID] = true;
        }

        if ($this->aParentShop !== null && $this->aParentShop->getId() !== $v) {
            $this->aParentShop = null;
        }

        return $this;
    } // setParentId()

    /**
     * Set the value of [domain_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setDomainId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->domain_id !== $v) {
            $this->domain_id = $v;
            $this->modifiedColumns[ShopTableMap::COL_DOMAIN_ID] = true;
        }

        if ($this->aDomain !== null && $this->aDomain->getId() !== $v) {
            $this->aDomain = null;
        }

        return $this;
    } // setDomainId()

    /**
     * Set the value of [active] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function setActive($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->active !== $v) {
            $this->active = $v;
            $this->modifiedColumns[ShopTableMap::COL_ACTIVE] = true;
        }

        return $this;
    } // setActive()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->type !== 'main') {
                return false;
            }

            if ($this->active !== 'Y') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : ShopTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : ShopTableMap::translateFieldName('Title', TableMap::TYPE_PHPNAME, $indexType)];
            $this->title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : ShopTableMap::translateFieldName('Desc', TableMap::TYPE_PHPNAME, $indexType)];
            $this->desc = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : ShopTableMap::translateFieldName('Image', TableMap::TYPE_PHPNAME, $indexType)];
            $this->image = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : ShopTableMap::translateFieldName('Logo', TableMap::TYPE_PHPNAME, $indexType)];
            $this->logo = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : ShopTableMap::translateFieldName('directorContact', TableMap::TYPE_PHPNAME, $indexType)];
            $this->director_contact = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : ShopTableMap::translateFieldName('Phones', TableMap::TYPE_PHPNAME, $indexType)];
            $this->phones = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : ShopTableMap::translateFieldName('emails', TableMap::TYPE_PHPNAME, $indexType)];
            $this->emails = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : ShopTableMap::translateFieldName('Type', TableMap::TYPE_PHPNAME, $indexType)];
            $this->type = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : ShopTableMap::translateFieldName('ParentId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->parent_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : ShopTableMap::translateFieldName('DomainId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->domain_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : ShopTableMap::translateFieldName('Active', TableMap::TYPE_PHPNAME, $indexType)];
            $this->active = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 12; // 12 = ShopTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Models\\Shop\\Shop'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
        if ($this->aParentShop !== null && $this->parent_id !== $this->aParentShop->getId()) {
            $this->aParentShop = null;
        }
        if ($this->aDomain !== null && $this->domain_id !== $this->aDomain->getId()) {
            $this->aDomain = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildShopQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aParentShop = null;
            $this->aDomain = null;
            $this->collShopsRelatedById = null;

            $this->collManagers = null;

            $this->collOrders = null;

            $this->collProviders = null;

            $this->singleAddress = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see Shop::setDeleted()
     * @see Shop::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildShopQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // archivable behavior
            if ($ret) {
                if ($this->archiveOnDelete) {
                    // do nothing yet. The object will be archived later when calling ChildShopQuery::delete().
                } else {
                    $deleteQuery->setArchiveOnDelete(false);
                    $this->archiveOnDelete = true;
                }
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ShopTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aParentShop !== null) {
                if ($this->aParentShop->isModified() || $this->aParentShop->isNew()) {
                    $affectedRows += $this->aParentShop->save($con);
                }
                $this->setParentShop($this->aParentShop);
            }

            if ($this->aDomain !== null) {
                if ($this->aDomain->isModified() || $this->aDomain->isNew()) {
                    $affectedRows += $this->aDomain->save($con);
                }
                $this->setDomain($this->aDomain);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->shopsRelatedByIdScheduledForDeletion !== null) {
                if (!$this->shopsRelatedByIdScheduledForDeletion->isEmpty()) {
                    foreach ($this->shopsRelatedByIdScheduledForDeletion as $shopRelatedById) {
                        // need to save related object because we set the relation to null
                        $shopRelatedById->save($con);
                    }
                    $this->shopsRelatedByIdScheduledForDeletion = null;
                }
            }

            if ($this->collShopsRelatedById !== null) {
                foreach ($this->collShopsRelatedById as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->managersScheduledForDeletion !== null) {
                if (!$this->managersScheduledForDeletion->isEmpty()) {
                    \Shop\Models\Manager\ManagerQuery::create()
                        ->filterByPrimaryKeys($this->managersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->managersScheduledForDeletion = null;
                }
            }

            if ($this->collManagers !== null) {
                foreach ($this->collManagers as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->ordersScheduledForDeletion !== null) {
                if (!$this->ordersScheduledForDeletion->isEmpty()) {
                    \Shop\Models\Order\OrderQuery::create()
                        ->filterByPrimaryKeys($this->ordersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->ordersScheduledForDeletion = null;
                }
            }

            if ($this->collOrders !== null) {
                foreach ($this->collOrders as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->providersScheduledForDeletion !== null) {
                if (!$this->providersScheduledForDeletion->isEmpty()) {
                    \Shop\Models\Provider\ProviderQuery::create()
                        ->filterByPrimaryKeys($this->providersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->providersScheduledForDeletion = null;
                }
            }

            if ($this->collProviders !== null) {
                foreach ($this->collProviders as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->singleAddress !== null) {
                if (!$this->singleAddress->isDeleted() && ($this->singleAddress->isNew() || $this->singleAddress->isModified())) {
                    $affectedRows += $this->singleAddress->save($con);
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[ShopTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ShopTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ShopTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`title`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_DESC)) {
            $modifiedColumns[':p' . $index++]  = '`desc`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_IMAGE)) {
            $modifiedColumns[':p' . $index++]  = '`image`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_LOGO)) {
            $modifiedColumns[':p' . $index++]  = '`logo`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_DIRECTOR_CONTACT)) {
            $modifiedColumns[':p' . $index++]  = '`director_contact`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_PHONES)) {
            $modifiedColumns[':p' . $index++]  = '`phones`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_EMAILS)) {
            $modifiedColumns[':p' . $index++]  = '`emails`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`type`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_PARENT_ID)) {
            $modifiedColumns[':p' . $index++]  = '`parent_id`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_DOMAIN_ID)) {
            $modifiedColumns[':p' . $index++]  = '`domain_id`';
        }
        if ($this->isColumnModified(ShopTableMap::COL_ACTIVE)) {
            $modifiedColumns[':p' . $index++]  = '`active`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_shops` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`title`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`desc`':
                        $stmt->bindValue($identifier, $this->desc, PDO::PARAM_STR);
                        break;
                    case '`image`':
                        $stmt->bindValue($identifier, $this->image, PDO::PARAM_STR);
                        break;
                    case '`logo`':
                        $stmt->bindValue($identifier, $this->logo, PDO::PARAM_STR);
                        break;
                    case '`director_contact`':
                        $stmt->bindValue($identifier, $this->director_contact, PDO::PARAM_STR);
                        break;
                    case '`phones`':
                        $stmt->bindValue($identifier, $this->phones, PDO::PARAM_STR);
                        break;
                    case '`emails`':
                        $stmt->bindValue($identifier, $this->emails, PDO::PARAM_STR);
                        break;
                    case '`type`':
                        $stmt->bindValue($identifier, $this->type, PDO::PARAM_STR);
                        break;
                    case '`parent_id`':
                        $stmt->bindValue($identifier, $this->parent_id, PDO::PARAM_INT);
                        break;
                    case '`domain_id`':
                        $stmt->bindValue($identifier, $this->domain_id, PDO::PARAM_INT);
                        break;
                    case '`active`':
                        $stmt->bindValue($identifier, $this->active, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = ShopTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getTitle();
                break;
            case 2:
                return $this->getDesc();
                break;
            case 3:
                return $this->getImage();
                break;
            case 4:
                return $this->getLogo();
                break;
            case 5:
                return $this->getdirectorContact();
                break;
            case 6:
                return $this->getPhones();
                break;
            case 7:
                return $this->getemails();
                break;
            case 8:
                return $this->getType();
                break;
            case 9:
                return $this->getParentId();
                break;
            case 10:
                return $this->getDomainId();
                break;
            case 11:
                return $this->getActive();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['Shop'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Shop'][$this->hashCode()] = true;
        $keys = ShopTableMap::getFieldNames($keyType);
        $keys_shop_addresses = \Shop\Models\Address\Map\AddressTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getDesc(),
            $keys[3] => $this->getImage(),
            $keys[4] => $this->getLogo(),
            $keys[5] => $this->getdirectorContact(),
            $keys[6] => $this->getPhones(),
            $keys[7] => $this->getemails(),
            $keys[8] => $this->getType(),
            $keys[9] => $this->getParentId(),
            $keys[10] => $this->getDomainId(),
            $keys[11] => $this->getActive(),
            $keys_shop_addresses[0] => $this->getPostCode(),
            $keys_shop_addresses[1] => $this->getStreet(),
            $keys_shop_addresses[2] => $this->getHouse(),
            $keys_shop_addresses[3] => $this->getRoom(),
            $keys_shop_addresses[4] => $this->getCityId(),
            $keys_shop_addresses[5] => $this->getMapLng(),
            $keys_shop_addresses[6] => $this->getMapLat(),

        );
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aParentShop) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'shop';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_shops';
                        break;
                    default:
                        $key = 'ParentShop';
                }

                $result[$key] = $this->aParentShop->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aDomain) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'domain';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_domains';
                        break;
                    default:
                        $key = 'Domain';
                }

                $result[$key] = $this->aDomain->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collShopsRelatedById) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'shops';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_shopss';
                        break;
                    default:
                        $key = 'Shops';
                }

                $result[$key] = $this->collShopsRelatedById->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collManagers) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'managers';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_managerss';
                        break;
                    default:
                        $key = 'Managers';
                }

                $result[$key] = $this->collManagers->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collOrders) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'orders';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_orderss';
                        break;
                    default:
                        $key = 'Orders';
                }

                $result[$key] = $this->collOrders->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProviders) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'providers';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_providerss';
                        break;
                    default:
                        $key = 'Providers';
                }

                $result[$key] = $this->collProviders->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->singleAddress) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'address';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_addresses';
                        break;
                    default:
                        $key = 'Address';
                }

                $result[$key] = $this->singleAddress->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Shop\Models\Shop\Shop
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = ShopTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Shop\Models\Shop\Shop
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setDesc($value);
                break;
            case 3:
                $this->setImage($value);
                break;
            case 4:
                $this->setLogo($value);
                break;
            case 5:
                $this->setdirectorContact($value);
                break;
            case 6:
                $this->setPhones($value);
                break;
            case 7:
                $this->setemails($value);
                break;
            case 8:
                $this->setType($value);
                break;
            case 9:
                $this->setParentId($value);
                break;
            case 10:
                $this->setDomainId($value);
                break;
            case 11:
                $this->setActive($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = ShopTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setTitle($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setDesc($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setImage($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setLogo($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setdirectorContact($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setPhones($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setemails($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setType($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setParentId($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setDomainId($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setActive($arr[$keys[11]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Shop\Models\Shop\Shop The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(ShopTableMap::DATABASE_NAME);

        if ($this->isColumnModified(ShopTableMap::COL_ID)) {
            $criteria->add(ShopTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(ShopTableMap::COL_TITLE)) {
            $criteria->add(ShopTableMap::COL_TITLE, $this->title);
        }
        if ($this->isColumnModified(ShopTableMap::COL_DESC)) {
            $criteria->add(ShopTableMap::COL_DESC, $this->desc);
        }
        if ($this->isColumnModified(ShopTableMap::COL_IMAGE)) {
            $criteria->add(ShopTableMap::COL_IMAGE, $this->image);
        }
        if ($this->isColumnModified(ShopTableMap::COL_LOGO)) {
            $criteria->add(ShopTableMap::COL_LOGO, $this->logo);
        }
        if ($this->isColumnModified(ShopTableMap::COL_DIRECTOR_CONTACT)) {
            $criteria->add(ShopTableMap::COL_DIRECTOR_CONTACT, $this->director_contact);
        }
        if ($this->isColumnModified(ShopTableMap::COL_PHONES)) {
            $criteria->add(ShopTableMap::COL_PHONES, $this->phones);
        }
        if ($this->isColumnModified(ShopTableMap::COL_EMAILS)) {
            $criteria->add(ShopTableMap::COL_EMAILS, $this->emails);
        }
        if ($this->isColumnModified(ShopTableMap::COL_TYPE)) {
            $criteria->add(ShopTableMap::COL_TYPE, $this->type);
        }
        if ($this->isColumnModified(ShopTableMap::COL_PARENT_ID)) {
            $criteria->add(ShopTableMap::COL_PARENT_ID, $this->parent_id);
        }
        if ($this->isColumnModified(ShopTableMap::COL_DOMAIN_ID)) {
            $criteria->add(ShopTableMap::COL_DOMAIN_ID, $this->domain_id);
        }
        if ($this->isColumnModified(ShopTableMap::COL_ACTIVE)) {
            $criteria->add(ShopTableMap::COL_ACTIVE, $this->active);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildShopQuery::create();
        $criteria->add(ShopTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Shop\Models\Shop\Shop (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setDesc($this->getDesc());
        $copyObj->setImage($this->getImage());
        $copyObj->setLogo($this->getLogo());
        $copyObj->setdirectorContact($this->getdirectorContact());
        $copyObj->setPhones($this->getPhones());
        $copyObj->setemails($this->getemails());
        $copyObj->setType($this->getType());
        $copyObj->setParentId($this->getParentId());
        $copyObj->setDomainId($this->getDomainId());
        $copyObj->setActive($this->getActive());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getShopsRelatedById() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addShopRelatedById($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getManagers() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addManager($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getOrders() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addOrder($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProviders() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProvider($relObj->copy($deepCopy));
                }
            }

            $relObj = $this->getAddress();
            if ($relObj) {
                $copyObj->setAddress($relObj->copy($deepCopy));
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Models\Shop\Shop Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a ChildShop object.
     *
     * @param  ChildShop $v
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     * @throws PropelException
     */
    public function setParentShop(ChildShop $v = null)
    {
        if ($v === null) {
            $this->setParentId(NULL);
        } else {
            $this->setParentId($v->getId());
        }

        $this->aParentShop = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ChildShop object, it will not be re-added.
        if ($v !== null) {
            $v->addShopRelatedById($this);
        }


        return $this;
    }


    /**
     * Get the associated ChildShop object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return ChildShop The associated ChildShop object.
     * @throws PropelException
     */
    public function getParentShop(ConnectionInterface $con = null)
    {
        if ($this->aParentShop === null && ($this->parent_id != 0)) {
            $this->aParentShop = ChildShopQuery::create()->findPk($this->parent_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aParentShop->addShopsRelatedById($this);
             */
        }

        return $this->aParentShop;
    }

    /**
     * Declares an association between this object and a Domain object.
     *
     * @param  Domain $v
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     * @throws PropelException
     */
    public function setDomain(Domain $v = null)
    {
        if ($v === null) {
            $this->setDomainId(NULL);
        } else {
            $this->setDomainId($v->getId());
        }

        $this->aDomain = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Domain object, it will not be re-added.
        if ($v !== null) {
            $v->addShop($this);
        }


        return $this;
    }


    /**
     * Get the associated Domain object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Domain The associated Domain object.
     * @throws PropelException
     */
    public function getDomain(ConnectionInterface $con = null)
    {
        if ($this->aDomain === null && ($this->domain_id != 0)) {
            $this->aDomain = DomainQuery::create()->findPk($this->domain_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aDomain->addShops($this);
             */
        }

        return $this->aDomain;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('ShopRelatedById' == $relationName) {
            $this->initShopsRelatedById();
            return;
        }
        if ('Manager' == $relationName) {
            $this->initManagers();
            return;
        }
        if ('Order' == $relationName) {
            $this->initOrders();
            return;
        }
        if ('Provider' == $relationName) {
            $this->initProviders();
            return;
        }
    }

    /**
     * Clears out the collShopsRelatedById collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addShopsRelatedById()
     */
    public function clearShopsRelatedById()
    {
        $this->collShopsRelatedById = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collShopsRelatedById collection loaded partially.
     */
    public function resetPartialShopsRelatedById($v = true)
    {
        $this->collShopsRelatedByIdPartial = $v;
    }

    /**
     * Initializes the collShopsRelatedById collection.
     *
     * By default this just sets the collShopsRelatedById collection to an empty array (like clearcollShopsRelatedById());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initShopsRelatedById($overrideExisting = true)
    {
        if (null !== $this->collShopsRelatedById && !$overrideExisting) {
            return;
        }

        $collectionClassName = ShopTableMap::getTableMap()->getCollectionClassName();

        $this->collShopsRelatedById = new $collectionClassName;
        $this->collShopsRelatedById->setModel('\Shop\Models\Shop\Shop');
    }

    /**
     * Gets an array of ChildShop objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildShop is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|ChildShop[] List of ChildShop objects
     * @throws PropelException
     */
    public function getShopsRelatedById(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collShopsRelatedByIdPartial && !$this->isNew();
        if (null === $this->collShopsRelatedById || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collShopsRelatedById) {
                // return empty collection
                $this->initShopsRelatedById();
            } else {
                $collShopsRelatedById = ChildShopQuery::create(null, $criteria)
                    ->filterByParentShop($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collShopsRelatedByIdPartial && count($collShopsRelatedById)) {
                        $this->initShopsRelatedById(false);

                        foreach ($collShopsRelatedById as $obj) {
                            if (false == $this->collShopsRelatedById->contains($obj)) {
                                $this->collShopsRelatedById->append($obj);
                            }
                        }

                        $this->collShopsRelatedByIdPartial = true;
                    }

                    return $collShopsRelatedById;
                }

                if ($partial && $this->collShopsRelatedById) {
                    foreach ($this->collShopsRelatedById as $obj) {
                        if ($obj->isNew()) {
                            $collShopsRelatedById[] = $obj;
                        }
                    }
                }

                $this->collShopsRelatedById = $collShopsRelatedById;
                $this->collShopsRelatedByIdPartial = false;
            }
        }

        return $this->collShopsRelatedById;
    }

    /**
     * Sets a collection of ChildShop objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $shopsRelatedById A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function setShopsRelatedById(Collection $shopsRelatedById, ConnectionInterface $con = null)
    {
        /** @var ChildShop[] $shopsRelatedByIdToDelete */
        $shopsRelatedByIdToDelete = $this->getShopsRelatedById(new Criteria(), $con)->diff($shopsRelatedById);


        $this->shopsRelatedByIdScheduledForDeletion = $shopsRelatedByIdToDelete;

        foreach ($shopsRelatedByIdToDelete as $shopRelatedByIdRemoved) {
            $shopRelatedByIdRemoved->setParentShop(null);
        }

        $this->collShopsRelatedById = null;
        foreach ($shopsRelatedById as $shopRelatedById) {
            $this->addShopRelatedById($shopRelatedById);
        }

        $this->collShopsRelatedById = $shopsRelatedById;
        $this->collShopsRelatedByIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related Shop objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related Shop objects.
     * @throws PropelException
     */
    public function countShopsRelatedById(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collShopsRelatedByIdPartial && !$this->isNew();
        if (null === $this->collShopsRelatedById || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collShopsRelatedById) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getShopsRelatedById());
            }

            $query = ChildShopQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByParentShop($this)
                ->count($con);
        }

        return count($this->collShopsRelatedById);
    }

    /**
     * Method called to associate a ChildShop object to this object
     * through the ChildShop foreign key attribute.
     *
     * @param  ChildShop $l ChildShop
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function addShopRelatedById(ChildShop $l)
    {
        if ($this->collShopsRelatedById === null) {
            $this->initShopsRelatedById();
            $this->collShopsRelatedByIdPartial = true;
        }

        if (!$this->collShopsRelatedById->contains($l)) {
            $this->doAddShopRelatedById($l);

            if ($this->shopsRelatedByIdScheduledForDeletion and $this->shopsRelatedByIdScheduledForDeletion->contains($l)) {
                $this->shopsRelatedByIdScheduledForDeletion->remove($this->shopsRelatedByIdScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ChildShop $shopRelatedById The ChildShop object to add.
     */
    protected function doAddShopRelatedById(ChildShop $shopRelatedById)
    {
        $this->collShopsRelatedById[]= $shopRelatedById;
        $shopRelatedById->setParentShop($this);
    }

    /**
     * @param  ChildShop $shopRelatedById The ChildShop object to remove.
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function removeShopRelatedById(ChildShop $shopRelatedById)
    {
        if ($this->getShopsRelatedById()->contains($shopRelatedById)) {
            $pos = $this->collShopsRelatedById->search($shopRelatedById);
            $this->collShopsRelatedById->remove($pos);
            if (null === $this->shopsRelatedByIdScheduledForDeletion) {
                $this->shopsRelatedByIdScheduledForDeletion = clone $this->collShopsRelatedById;
                $this->shopsRelatedByIdScheduledForDeletion->clear();
            }
            $this->shopsRelatedByIdScheduledForDeletion[]= $shopRelatedById;
            $shopRelatedById->setParentShop(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Shop is new, it will return
     * an empty collection; or if this Shop has previously
     * been saved, it will retrieve related ShopsRelatedById from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Shop.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|ChildShop[] List of ChildShop objects
     */
    public function getShopsRelatedByIdJoinDomain(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ChildShopQuery::create(null, $criteria);
        $query->joinWith('Domain', $joinBehavior);

        return $this->getShopsRelatedById($query, $con);
    }

    /**
     * Clears out the collManagers collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addManagers()
     */
    public function clearManagers()
    {
        $this->collManagers = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collManagers collection loaded partially.
     */
    public function resetPartialManagers($v = true)
    {
        $this->collManagersPartial = $v;
    }

    /**
     * Initializes the collManagers collection.
     *
     * By default this just sets the collManagers collection to an empty array (like clearcollManagers());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initManagers($overrideExisting = true)
    {
        if (null !== $this->collManagers && !$overrideExisting) {
            return;
        }

        $collectionClassName = ManagerTableMap::getTableMap()->getCollectionClassName();

        $this->collManagers = new $collectionClassName;
        $this->collManagers->setModel('\Shop\Models\Manager\Manager');
    }

    /**
     * Gets an array of Manager objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildShop is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|Manager[] List of Manager objects
     * @throws PropelException
     */
    public function getManagers(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collManagersPartial && !$this->isNew();
        if (null === $this->collManagers || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collManagers) {
                // return empty collection
                $this->initManagers();
            } else {
                $collManagers = ManagerQuery::create(null, $criteria)
                    ->filterByShop($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collManagersPartial && count($collManagers)) {
                        $this->initManagers(false);

                        foreach ($collManagers as $obj) {
                            if (false == $this->collManagers->contains($obj)) {
                                $this->collManagers->append($obj);
                            }
                        }

                        $this->collManagersPartial = true;
                    }

                    return $collManagers;
                }

                if ($partial && $this->collManagers) {
                    foreach ($this->collManagers as $obj) {
                        if ($obj->isNew()) {
                            $collManagers[] = $obj;
                        }
                    }
                }

                $this->collManagers = $collManagers;
                $this->collManagersPartial = false;
            }
        }

        return $this->collManagers;
    }

    /**
     * Sets a collection of Manager objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $managers A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function setManagers(Collection $managers, ConnectionInterface $con = null)
    {
        /** @var Manager[] $managersToDelete */
        $managersToDelete = $this->getManagers(new Criteria(), $con)->diff($managers);


        $this->managersScheduledForDeletion = $managersToDelete;

        foreach ($managersToDelete as $managerRemoved) {
            $managerRemoved->setShop(null);
        }

        $this->collManagers = null;
        foreach ($managers as $manager) {
            $this->addManager($manager);
        }

        $this->collManagers = $managers;
        $this->collManagersPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseManager objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseManager objects.
     * @throws PropelException
     */
    public function countManagers(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collManagersPartial && !$this->isNew();
        if (null === $this->collManagers || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collManagers) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getManagers());
            }

            $query = ManagerQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByShop($this)
                ->count($con);
        }

        return count($this->collManagers);
    }

    /**
     * Method called to associate a Manager object to this object
     * through the Manager foreign key attribute.
     *
     * @param  Manager $l Manager
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function addManager(Manager $l)
    {
        if ($this->collManagers === null) {
            $this->initManagers();
            $this->collManagersPartial = true;
        }

        if (!$this->collManagers->contains($l)) {
            $this->doAddManager($l);

            if ($this->managersScheduledForDeletion and $this->managersScheduledForDeletion->contains($l)) {
                $this->managersScheduledForDeletion->remove($this->managersScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Manager $manager The Manager object to add.
     */
    protected function doAddManager(Manager $manager)
    {
        $this->collManagers[]= $manager;
        $manager->setShop($this);
    }

    /**
     * @param  Manager $manager The Manager object to remove.
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function removeManager(Manager $manager)
    {
        if ($this->getManagers()->contains($manager)) {
            $pos = $this->collManagers->search($manager);
            $this->collManagers->remove($pos);
            if (null === $this->managersScheduledForDeletion) {
                $this->managersScheduledForDeletion = clone $this->collManagers;
                $this->managersScheduledForDeletion->clear();
            }
            $this->managersScheduledForDeletion[]= clone $manager;
            $manager->setShop(null);
        }

        return $this;
    }

    /**
     * Clears out the collOrders collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addOrders()
     */
    public function clearOrders()
    {
        $this->collOrders = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collOrders collection loaded partially.
     */
    public function resetPartialOrders($v = true)
    {
        $this->collOrdersPartial = $v;
    }

    /**
     * Initializes the collOrders collection.
     *
     * By default this just sets the collOrders collection to an empty array (like clearcollOrders());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initOrders($overrideExisting = true)
    {
        if (null !== $this->collOrders && !$overrideExisting) {
            return;
        }

        $collectionClassName = OrderTableMap::getTableMap()->getCollectionClassName();

        $this->collOrders = new $collectionClassName;
        $this->collOrders->setModel('\Shop\Models\Order\Order');
    }

    /**
     * Gets an array of Order objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildShop is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|Order[] List of Order objects
     * @throws PropelException
     */
    public function getOrders(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collOrdersPartial && !$this->isNew();
        if (null === $this->collOrders || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collOrders) {
                // return empty collection
                $this->initOrders();
            } else {
                $collOrders = OrderQuery::create(null, $criteria)
                    ->filterByShop($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collOrdersPartial && count($collOrders)) {
                        $this->initOrders(false);

                        foreach ($collOrders as $obj) {
                            if (false == $this->collOrders->contains($obj)) {
                                $this->collOrders->append($obj);
                            }
                        }

                        $this->collOrdersPartial = true;
                    }

                    return $collOrders;
                }

                if ($partial && $this->collOrders) {
                    foreach ($this->collOrders as $obj) {
                        if ($obj->isNew()) {
                            $collOrders[] = $obj;
                        }
                    }
                }

                $this->collOrders = $collOrders;
                $this->collOrdersPartial = false;
            }
        }

        return $this->collOrders;
    }

    /**
     * Sets a collection of Order objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $orders A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function setOrders(Collection $orders, ConnectionInterface $con = null)
    {
        /** @var Order[] $ordersToDelete */
        $ordersToDelete = $this->getOrders(new Criteria(), $con)->diff($orders);


        $this->ordersScheduledForDeletion = $ordersToDelete;

        foreach ($ordersToDelete as $orderRemoved) {
            $orderRemoved->setShop(null);
        }

        $this->collOrders = null;
        foreach ($orders as $order) {
            $this->addOrder($order);
        }

        $this->collOrders = $orders;
        $this->collOrdersPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseOrder objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseOrder objects.
     * @throws PropelException
     */
    public function countOrders(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collOrdersPartial && !$this->isNew();
        if (null === $this->collOrders || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collOrders) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getOrders());
            }

            $query = OrderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByShop($this)
                ->count($con);
        }

        return count($this->collOrders);
    }

    /**
     * Method called to associate a Order object to this object
     * through the Order foreign key attribute.
     *
     * @param  Order $l Order
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function addOrder(Order $l)
    {
        if ($this->collOrders === null) {
            $this->initOrders();
            $this->collOrdersPartial = true;
        }

        if (!$this->collOrders->contains($l)) {
            $this->doAddOrder($l);

            if ($this->ordersScheduledForDeletion and $this->ordersScheduledForDeletion->contains($l)) {
                $this->ordersScheduledForDeletion->remove($this->ordersScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Order $order The Order object to add.
     */
    protected function doAddOrder(Order $order)
    {
        $this->collOrders[]= $order;
        $order->setShop($this);
    }

    /**
     * @param  Order $order The Order object to remove.
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function removeOrder(Order $order)
    {
        if ($this->getOrders()->contains($order)) {
            $pos = $this->collOrders->search($order);
            $this->collOrders->remove($pos);
            if (null === $this->ordersScheduledForDeletion) {
                $this->ordersScheduledForDeletion = clone $this->collOrders;
                $this->ordersScheduledForDeletion->clear();
            }
            $this->ordersScheduledForDeletion[]= clone $order;
            $order->setShop(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Shop is new, it will return
     * an empty collection; or if this Shop has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Shop.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinCustomer(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Customer', $joinBehavior);

        return $this->getOrders($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Shop is new, it will return
     * an empty collection; or if this Shop has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Shop.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinPayment(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Payment', $joinBehavior);

        return $this->getOrders($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Shop is new, it will return
     * an empty collection; or if this Shop has previously
     * been saved, it will retrieve related Orders from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Shop.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     */
    public function getOrdersJoinState(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('State', $joinBehavior);

        return $this->getOrders($query, $con);
    }

    /**
     * Clears out the collProviders collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addProviders()
     */
    public function clearProviders()
    {
        $this->collProviders = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collProviders collection loaded partially.
     */
    public function resetPartialProviders($v = true)
    {
        $this->collProvidersPartial = $v;
    }

    /**
     * Initializes the collProviders collection.
     *
     * By default this just sets the collProviders collection to an empty array (like clearcollProviders());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProviders($overrideExisting = true)
    {
        if (null !== $this->collProviders && !$overrideExisting) {
            return;
        }

        $collectionClassName = ProviderTableMap::getTableMap()->getCollectionClassName();

        $this->collProviders = new $collectionClassName;
        $this->collProviders->setModel('\Shop\Models\Provider\Provider');
    }

    /**
     * Gets an array of Provider objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildShop is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|Provider[] List of Provider objects
     * @throws PropelException
     */
    public function getProviders(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collProvidersPartial && !$this->isNew();
        if (null === $this->collProviders || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collProviders) {
                // return empty collection
                $this->initProviders();
            } else {
                $collProviders = ProviderQuery::create(null, $criteria)
                    ->filterByShop($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collProvidersPartial && count($collProviders)) {
                        $this->initProviders(false);

                        foreach ($collProviders as $obj) {
                            if (false == $this->collProviders->contains($obj)) {
                                $this->collProviders->append($obj);
                            }
                        }

                        $this->collProvidersPartial = true;
                    }

                    return $collProviders;
                }

                if ($partial && $this->collProviders) {
                    foreach ($this->collProviders as $obj) {
                        if ($obj->isNew()) {
                            $collProviders[] = $obj;
                        }
                    }
                }

                $this->collProviders = $collProviders;
                $this->collProvidersPartial = false;
            }
        }

        return $this->collProviders;
    }

    /**
     * Sets a collection of Provider objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $providers A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function setProviders(Collection $providers, ConnectionInterface $con = null)
    {
        /** @var Provider[] $providersToDelete */
        $providersToDelete = $this->getProviders(new Criteria(), $con)->diff($providers);


        $this->providersScheduledForDeletion = $providersToDelete;

        foreach ($providersToDelete as $providerRemoved) {
            $providerRemoved->setShop(null);
        }

        $this->collProviders = null;
        foreach ($providers as $provider) {
            $this->addProvider($provider);
        }

        $this->collProviders = $providers;
        $this->collProvidersPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseProvider objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseProvider objects.
     * @throws PropelException
     */
    public function countProviders(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collProvidersPartial && !$this->isNew();
        if (null === $this->collProviders || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProviders) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getProviders());
            }

            $query = ProviderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByShop($this)
                ->count($con);
        }

        return count($this->collProviders);
    }

    /**
     * Method called to associate a Provider object to this object
     * through the Provider foreign key attribute.
     *
     * @param  Provider $l Provider
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     */
    public function addProvider(Provider $l)
    {
        if ($this->collProviders === null) {
            $this->initProviders();
            $this->collProvidersPartial = true;
        }

        if (!$this->collProviders->contains($l)) {
            $this->doAddProvider($l);

            if ($this->providersScheduledForDeletion and $this->providersScheduledForDeletion->contains($l)) {
                $this->providersScheduledForDeletion->remove($this->providersScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Provider $provider The Provider object to add.
     */
    protected function doAddProvider(Provider $provider)
    {
        $this->collProviders[]= $provider;
        $provider->setShop($this);
    }

    /**
     * @param  Provider $provider The Provider object to remove.
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function removeProvider(Provider $provider)
    {
        if ($this->getProviders()->contains($provider)) {
            $pos = $this->collProviders->search($provider);
            $this->collProviders->remove($pos);
            if (null === $this->providersScheduledForDeletion) {
                $this->providersScheduledForDeletion = clone $this->collProviders;
                $this->providersScheduledForDeletion->clear();
            }
            $this->providersScheduledForDeletion[]= clone $provider;
            $provider->setShop(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Shop is new, it will return
     * an empty collection; or if this Shop has previously
     * been saved, it will retrieve related Providers from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Shop.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Provider[] List of Provider objects
     */
    public function getProvidersJoinCurrency(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ProviderQuery::create(null, $criteria);
        $query->joinWith('Currency', $joinBehavior);

        return $this->getProviders($query, $con);
    }

    /**
     * Gets a single Address object, which is related to this object by a one-to-one relationship.
     *
     * @param  ConnectionInterface $con optional connection object
     * @return Address
     * @throws PropelException
     */
    public function getAddress(ConnectionInterface $con = null)
    {

        if ($this->singleAddress === null && !$this->isNew()) {
            $this->singleAddress = AddressQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleAddress;
    }

    /**
     * Sets a single Address object as related to this object by a one-to-one relationship.
     *
     * @param  Address $v Address
     * @return $this|\Shop\Models\Shop\Shop The current object (for fluent API support)
     * @throws PropelException
     */
    public function setAddress(Address $v = null)
    {
        $this->singleAddress = $v;

        // Make sure that that the passed-in Address isn't already associated with this object
        if ($v !== null && $v->getShop(null, false) === null) {
            $v->setShop($this);
        }

        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        if (null !== $this->aParentShop) {
            $this->aParentShop->removeShopRelatedById($this);
        }
        if (null !== $this->aDomain) {
            $this->aDomain->removeShop($this);
        }
        $this->id = null;
        $this->title = null;
        $this->desc = null;
        $this->image = null;
        $this->logo = null;
        $this->director_contact = null;
        $this->phones = null;
        $this->emails = null;
        $this->type = null;
        $this->parent_id = null;
        $this->domain_id = null;
        $this->active = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collShopsRelatedById) {
                foreach ($this->collShopsRelatedById as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collManagers) {
                foreach ($this->collManagers as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collOrders) {
                foreach ($this->collOrders as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProviders) {
                foreach ($this->collProviders as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->singleAddress) {
                $this->singleAddress->clearAllReferences($deep);
            }
        } // if ($deep)

        $this->collShopsRelatedById = null;
        $this->collManagers = null;
        $this->collOrders = null;
        $this->collProviders = null;
        $this->singleAddress = null;
        $this->aParentShop = null;
        $this->aDomain = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ShopTableMap::DEFAULT_STRING_FORMAT);
    }

    // archivable behavior

    /**
     * Get an archived version of the current object.
     *
     * @param ConnectionInterface $con Optional connection object
     *
     * @return     ChildShopShopsArchive An archive object, or null if the current object was never archived
     */
    public function getArchive(ConnectionInterface $con = null)
    {
        if ($this->isNew()) {
            return null;
        }
        $archive = ChildShopShopsArchiveQuery::create()
            ->filterByPrimaryKey($this->getPrimaryKey())
            ->findOne($con);

        return $archive;
    }
    /**
     * Copy the data of the current object into a $archiveTablePhpName archive object.
     * The archived object is then saved.
     * If the current object has already been archived, the archived object
     * is updated and not duplicated.
     *
     * @param ConnectionInterface $con Optional connection object
     *
     * @throws PropelException If the object is new
     *
     * @return     ChildShopShopsArchive The archive object based on this object
     */
    public function archive(ConnectionInterface $con = null)
    {
        if ($this->isNew()) {
            throw new PropelException('New objects cannot be archived. You must save the current object before calling archive().');
        }
        $archive = $this->getArchive($con);
        if (!$archive) {
            $archive = new ChildShopShopsArchive();
            $archive->setPrimaryKey($this->getPrimaryKey());
        }
        $this->copyInto($archive, $deepCopy = false, $makeNew = false);
        $archive->setArchivedAt(time());
        $archive->save($con);

        return $archive;
    }

    /**
     * Revert the the current object to the state it had when it was last archived.
     * The object must be saved afterwards if the changes must persist.
     *
     * @param ConnectionInterface $con Optional connection object
     *
     * @throws PropelException If the object has no corresponding archive.
     *
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function restoreFromArchive(ConnectionInterface $con = null)
    {
        $archive = $this->getArchive($con);
        if (!$archive) {
            throw new PropelException('The current object has never been archived and cannot be restored');
        }
        $this->populateFromArchive($archive);

        return $this;
    }

    /**
     * Populates the the current object based on a $archiveTablePhpName archive object.
     *
     * @param      ChildShopShopsArchive $archive An archived object based on the same class
      * @param      Boolean $populateAutoIncrementPrimaryKeys
     *               If true, autoincrement columns are copied from the archive object.
     *               If false, autoincrement columns are left intact.
      *
     * @return     ChildShop The current object (for fluent API support)
     */
    public function populateFromArchive($archive, $populateAutoIncrementPrimaryKeys = false) {
        if ($populateAutoIncrementPrimaryKeys) {
            $this->setId($archive->getId());
        }
        $this->setTitle($archive->getTitle());
        $this->setDesc($archive->getDesc());
        $this->setImage($archive->getImage());
        $this->setLogo($archive->getLogo());
        $this->setdirectorContact($archive->getdirectorContact());
        $this->setPhones($archive->getPhones());
        $this->setemails($archive->getemails());
        $this->setType($archive->getType());
        $this->setParentId($archive->getParentId());
        $this->setDomainId($archive->getDomainId());
        $this->setActive($archive->getActive());

        return $this;
    }

    /**
     * Removes the object from the database without archiving it.
     *
     * @param ConnectionInterface $con Optional connection object
     *
     * @return $this|ChildShop The current object (for fluent API support)
     */
    public function deleteWithoutArchive(ConnectionInterface $con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preSave')) {
            return parent::preSave($con);
        }
        return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postSave')) {
            parent::postSave($con);
        }
    }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preInsert')) {
            return parent::preInsert($con);
        }
        return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postInsert')) {
            parent::postInsert($con);
        }
    }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preUpdate')) {
            return parent::preUpdate($con);
        }
        return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postUpdate')) {
            parent::postUpdate($con);
        }
    }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preDelete')) {
            return parent::preDelete($con);
        }
        return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postDelete')) {
            parent::postDelete($con);
        }
    }


    /**
     * Catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {

    // delegate behavior

    if (is_callable(array('\Shop\Models\Address\Address', $name))) {
        $delegate = $this->getAddress();
        if (!$delegate) {
            $delegate = new Address();
            $this->setAddress($delegate);
        }

        return call_user_func_array(array($delegate, $name), $params);
    }
        return $this->__parentCall($name, $params);
    }

    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __parentCall($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
