<?php

namespace Shop\Models\Customer;

use Propel\Runtime\ActiveQuery\BaseModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Propel;
use Shop\Models\Customer\Base\Customer as BaseCustomer;
use Shop\Models\Product\Product;

/**
 * Skeleton subclass for representing a row from the 'shop_customer' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Customer extends BaseCustomer implements \Shop\Contracts\CustomerComplexInterface,
    \Shop\Contracts\CustomerAccessPricesInterface
{

    /**
     * Код созданный при регистрации
     * @var type
     */
    protected $registerCode;

    protected $access = false;


    /**
     * Доступ к прайс-листам клиента
     * @todo Удалить костыль перевести на настройки
     * @return type
     */
    public function getAccessPriceListScheetIds(): array
    {
        //dump($this->access);
        if ($this->access !== false) {
            return $this->access;
        }

        $con = Propel::getConnection(Propel::DEFAULT_NAME);
        $query = "SELECT
  `shop_price_access`.`id`,
  `shop_price_access`.`customer_group_id`,
  `shop_price_access`.`shop_id`,
  `shop_price_access`.`price_scheet_id`,
  `shop_price_access`.`customer_id`,
 sps.id AS scheet_id
FROM `shop_price_access`

    INNER JOIN shop_pricelist_sheets sps
    ON sps.id LIKE shop_price_access.price_scheet_id
  INNER JOIN shop_pricelist_files spf
    ON sps.pricelist_file_id = spf.id
  INNER JOIN shop_providers sp
    ON spf.provider_id = sp.id AND sp.shop_id = '" . $this->getManager()->getShopId() . "'

WHERE (('" . $this->getGroupId() . "' LIKE `customer_group_id`
AND '" . $this->getManager()->getShopId() . "' LIKE `shop_price_access`.`shop_id`)
AND '" . $this->getId() . "' LIKE `customer_id`)
ORDER BY `shop_price_access`.`customer_id` DESC,
  `shop_price_access`.`customer_group_id` DESC,
  `shop_price_access`.`shop_id` DESC 
  ";

        $stmt = $con->prepare($query);
        $prices = [];
        if ($stmt->execute()) {
            $res = $stmt->fetchAll();
            foreach ($res as $r) {
                $prices[] = $r["scheet_id"];
            }
        }


        return $prices;
    }

    /**
     *
     * @return string
     */
    function getRegisterCode(): string
    {
        return $this->registerCode;
    }

    /**
     *
     * @param string $registerCode
     * @return $this
     */
    function setRegisterCode(string $registerCode)
    {
        $this->registerCode = $registerCode;
        return $this;
    }

    /**
     * Разрешена ли отправка на email
     * @return bool
     */
    public function isNotifyEmail(): bool
    {

        if (strpos($this->getNotifyType(), "email") !== false) {
            return true;
        }

        return false;
    }

    /**
     * Разрешена ли отправка на sms
     * @return bool
     */
    public function isNotifySms(): bool
    {

        if (strpos($this->getNotifyType(), "sms") !== false) {
            return true;
        }

        return false;
    }

    /**
     * Полный адресс
     * @return type
     */
    public function getFullAddress(): string
    {

        $city = $this->getCustomerCity();
        $region = $city->getCityRegion();

        return sprintf(
            "%s, г.%s",
            $region->getName(),
            $city->getName()
        );
    }

    /**
     * Set the value of [discount] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Customer\Customer The current object (for fluent API support)
     */
    public function setDiscount($v)
    {

        if ($v !== null) {
            $v = (string)$v;
        }

        if ($v === "") {
            $v = null;
        }

        if ($this->discount !== $v) {
            $this->discount = $v;
            $this->modifiedColumns[CustomerTableMap::COL_DISCOUNT] = true;
        }

        return $this;
    }
}
