<?php
namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Customer\CustomerQuery;
use Shop\Models\Customer\Customer as CustomerEntity;
/**
 * Description of Brand
 *
 * @author Dmitriy
 */
class Customer extends PropelQueryAbstract implements CrudInterface, 
        \Core\Repository\DropdownInreface,
        \Shop\Contracts\ShopCurrentInterface
        {

    use \Shop\Concrete\ShopAuthUserTrait;
    
    public function buildEntity(){
	return new CustomerEntity;
    }

    public function buildQuery()
    {
        return CustomerQuery::create()
                        ->_if($this->curShop)
                            ->useManagerQuery()
                                ->filterByShop($this->curShop)
                            ->endUse()
                        ->_endif();
    }

    /**
     * 
     * @param type $email
     * @return CustomerEntity
     */
    public function findByEmail($email) {
        return $this
                ->buildQuery()
                ->findOneByEmail($email);
    }
    
    /**
     * 
     * @param type $email
     * @param type $pass
     * @return CustomerEntity
     */
    public function findByEmailPassword($email,$pass): ?CustomerEntity
    {
        return $this
                ->buildQuery()
                ->filterByEmail($email)
                ->filterByPassword($pass)
                ->findOne();
    }

    /**
     * @param string $pass
     * @return CustomerEntity
     */
    public function findByPassword(string $pass): ?CustomerEntity
    {
        return $this
            ->buildQuery()
            ->filterByPassword($pass)
            ->findOne();
    }
    
    /**
     * Вообще все клиенты
     * @return type
     */
    public function getDropdownList() {
        return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }    
    
    /**
     * Не заблокированные
     */
    public function countActive(){
        return $this->buildQuery()
                ->filterByBlocked("N")
                ->count();
    }
    
    /**
     * Получение последних клиентов
     * @param type $limit
     * @return \Propel\Runtime\Collection\Collection
     */
    public function findLastByLimit($limit,array $ignoreGroups): \Propel\Runtime\Collection\Collection
    {
        return $this->getQuery()
                ->limit($limit)
                ->filterByGroupId($ignoreGroups, \Propel\Runtime\ActiveQuery\Criteria::NOT_IN)
                ->orderById(\Propel\Runtime\ActiveQuery\Criteria::DESC)
                ->find();
    }
    
    public function findById($id){
	   return $this->buildQuery()->findPk($id);
    }    
}
