<?php

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Currency\Currency as CurrencyEntity;
use Shop\Models\Currency\CurrencyQuery;

/**
 * Description of Bonus
 *
 * @author Dmitriy
 */
class Currency extends PropelQueryAbstract implements CrudInterface, \Shop\Contracts\ShopCurrentInterface, 
        \Core\Repository\DropdownInreface
{
    use \Shop\Concrete\ShopAuthUserTrait;

    public function buildQuery()
    {

        $query = CurrencyQuery::create()
                ;
        //echo $query->toString();exit;
        return $query;
    }

    /**
     * 
     * @return CurrencyEntity
     */
    public function buildEntity()
    {
        return new CurrencyEntity;
    }

    public function getDropdownList(){
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }    
    

}