<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\Collection\ObjectCollection;
use Shop\Models\Country\Country as CountryEntity;
use Shop\Models\Country\CountryQuery;


/**
 * Description of Country
 *
 * @author Admin
 */
class Country extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropdownInreface{

    public function buildQuery(){
	return CountryQuery ::create();
    }

    public function buildEntity(){
	return new CountryEntity;
    }
    public function getDropdownList()
    {
        return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }

   
}
