<?

namespace Shop\Modules\AdminCountries;

use Core\Registry\Column;
use Core\Registry\Field;

/**
* Description of AdminCountries
*
* @author Diamond Code Generator
*/
class AdminCountries extends \Core\ModuleController{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\Country $repo)
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
    }    
    
    public function process() {
        
        $table = $this->tableFactory->buildAdminTable("countries", $this->repo);
        
        $table
                ->addColumn(new Column("id", "№", 30, false, true))
                ->addColumn(new Column("name", "Название", 120))
                ->addColumn(new Column("code", "Код страны", 150))
                ->addColumn(new Column("phoneMask", "Маска телефона", 150))
        ;   
        
        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("code"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("phoneMask"), null, "required", "может использоваться для ввода телефона"
                ))
                ;
        
        return $table->render();
    }

}               