<?

namespace Shop\Concrete;

use Shop\Models\Shop\Shop as ShopModel;
/**
 * Пустышка
 *
 * @author Admin
 */
class ShopByAuthUser implements \Shop\Contracts\ShopByAuthUserInterface
{

    protected $authService;

    static $shopByAuthUser;

    function __construct(\Shop\Services\Auth $authService)
    {
        $this->authService = $authService;
    }

    /**
     * 
     * @return type
     */
    public function getShopByAuthUser(): ShopModel
    {
        try {
            $user = $this->authService->getAuthUser();
        } catch (\Diamond\Exceptions\UserNotAuth $ex) {
            throw new \Shop\Exceptions\ShopNotFound("current shop by user not found");
        }

        if ($user->getUserGroup()->getGrpCode() === "root") {
            throw new \Shop\Exceptions\ShopUserIsRoot;
        }

        $shop = \Shop\Models\Shop\ShopQuery::create()
                ->useManagerQuery()
                ->filterByEmail($user->getEmail())
                ->endUse()
                ->findOne();

        if ( ! $shop) {
            throw new \Shop\Exceptions\ShopNotFound("current shop by user not found");
        }


        
        return $shop;
    }

}