<?

namespace Shop\Services;

/**
 * Класс работы с уведомлениями
 *
 * @author Admin
 */
class Notify extends \Diamond\Services\Notify
{

    protected $smsService;

    public function __construct(\Diamond\Config\Mail $mailConfig, 
            \Nette\Mail\SendmailMailer $mailer, \Shop\Services\Sms $smsService
            )
    {
        parent::__construct($mailConfig, $mailer);
        $this->smsService = $smsService;
    }

    /**
     * Отправка сообщения на смс
     * @param type $phone
     * @param \Diamond\DTO\Message $message
     */
    public function sendToSms($phone, \Diamond\DTO\Message $message):int
    {
        
        return $this->smsService->sendSms($phone, $message);
    }

}