<?

namespace Shop\Services;

/**
 * Бизнес логика для скидок
 *
 * @author Admin
 */
class Discount
{
    protected $discount;
    protected $customerService;
    protected $confMain;
            
    function __construct(\Shop\Repositories\Discount $discount,\Shop\Services\Customer  $customerService,\Shop\Config\Main $confMain)
    {
        $this->discount = $discount;
        $this->customerService = $customerService;
        $this->confMain = $confMain;
    }


    /**
     * Подсчет след.скидки
     * @param \Shop\DTO\Basket $basket
     * @return \Shop\DTO\Discount
     */
    public function calculateSummForNextDiscount(\Shop\DTO\Basket $basket): \Shop\DTO\Discount
    {
        
        $customer = $this->customerService->buildCurrentCustomer();
        
        if(is_array($this->confMain->getOrderDiscountIgnoreCustomerGroups()) &&
                in_array($customer->getGroupId(),$this->confMain->getOrderDiscountIgnoreCustomerGroups())){
            return new \Shop\DTO\Discount();
        }
        
        if(!$discount = $this->discount->getNextDiscount($basket->getSumm())){
            return new \Shop\DTO\Discount();
        }
        
        $summ = $discount->getPriceFrom() - $basket->getSumm();
        
        return (new \Shop\DTO\Discount())->setSumm((float)$summ)->setPercent($discount->getPercent());
    }
    
    /**
     * тек скидка
     * @param \Shop\DTO\Basket $basket
     * @return \Shop\DTO\Discount
     */
    public function calculateSummDiscount(\Shop\DTO\Basket $basket): \Shop\DTO\Discount
    {
        return $this->calculateDiscountBySumm($basket->getSumm());       
    }
    
    /**
     * 
     * @param type $summBasket
     * @return \Shop\DTO\Discount
     */
    public function calculateDiscountBySumm($summBasket)
    {
        $customer = $this->customerService->buildCurrentCustomer();
        
        if(is_array($this->confMain->getOrderDiscountIgnoreCustomerGroups())
                && in_array($customer->getGroupId(),$this->confMain->getOrderDiscountIgnoreCustomerGroups())){
            return new \Shop\DTO\Discount();
        }
                
        if(!$discount = $this->discount->getDiscount($summBasket)){
            return new \Shop\DTO\Discount();
        }
        
        $summ = $summBasket / 100  * $discount->getPercent();
        
        return (new \Shop\DTO\Discount())->setSumm((float)$summ)->setPercent($discount->getPercent());          
    }
}