<?

namespace Shop\Services;

/**
 * Use Case Basket
 *
 * @author Admin
 */
class Basket
{

    protected $basket;
    protected $main;

    function __construct(\Core\Basket\Basket $basket, \Shop\Config\Main $main)
    {
        $this->basket = $basket;
        $this->main = $main;
    }

    /**
     * Добавляем товар в корзину
     * @param \Shop\DTO\BasketItemRequest $item
     * @return integer
     */
    public function add(\Shop\DTO\BasketItemRequest $item): string
    {

        $key = $this->basket->addItem($item->getArtice(), $item->getPrice(), $item->getAmount(),
                                      [
            "name"  => $item->getName(),
            "desc"  => $item->getDesc(),
            "ref"   => $item->getRef(),
            "brand" => $item->getBrand(),
            "shop"  => $item->getShop(),
            "menagerComment"  => $item->getMenagerComment()
        ]);

        return $key;
    }

    /**
     * Проверка наличия товара
     * @param \Shop\DTO\BasketItemRequest $item
     * @return false|\Shop\DTO\BasketItem
     */
    public function itemExist(\Shop\DTO\BasketItemRequest $item): int
    {
        $key = $this->basket->createKey($item->getDesc(), $item->getPrice());
        if ( ! $item = $this->basket->getItemByKey($key)) {
            return 0;
        }
        return $this->buildItem($key, $item)->getAmount();
    }

    /**
     * получение кол-ва товара в корзине по ref позиции
     * @param type $ref
     */
    public function itemExistByRef($ref): int
    {

        foreach ($this->basket->getItems() as $item) {

            if ($item["data"]["ref"] == $ref) {

                return $item["amount"];
            }
        }

        return 0;
    }

    /**
     * Удаление по ключу
     * @param type $hash
     * @return boolean
     */
    public function delete($hash)
    {
        if ($this->basket->deleteByKey($hash) === true) {
            return true;
        }

        return false;
    }

    /**
     * Получение корзины
     * @return \Shop\DTO\Basket
     */
    public function getBasket(): \Shop\DTO\Basket
    {
        $count = $this->basket->getCount();
        $summ = $this->basket->getSumm();
        $items = [];
        foreach ($this->basket->getItems() as $k => $item) {
            $items[] = $this->buildItem($k, $item);
        }

        $basket = new \Shop\DTO\Basket($summ, $count, $items);

        return $basket;
    }
    
    /**
     * 
     * @return int
     */
    public function getScoresInBasket(): int
    {
        $scores = 0;

        foreach ($this->getBasket()->getItems() as $item) {
            if (strpos($item->getMenagerComment(),"score")!==false) {
                continue;
            }
            $scores = $scores + $item->getPrice() * $item->getAmount();
        }
        return abs($scores);
    }

    /**
     * 
     * @param type $k
     * @param array $item
     * @return type
     */
    private function buildItem($k, array $item): \Shop\DTO\BasketItem
    {

        return (new \Shop\DTO\BasketItem())
                        ->setId($k)
                        ->setPrice($item["price"])
                        ->setAmount($item["amount"])
                        ->setName($item["data"]["name"])
                        ->setArticle($item["article"])
                        ->setRef($item["data"]["ref"])
                        ->setBrand($item["data"]["brand"])
                        ->setDesc($item["data"]["desc"])
                        ->setShop($item["data"]["shop"])
                        ->setMenagerComment(isset($item["data"]["menagerComment"])?$item["data"]["menagerComment"]:null)
        ;
    }

    public function clearBasket()
    {
        $this->basket->clear();
        return true;
    }

    /**
     * 
     * @return int
     */
    public function calculateScore():int
    {
        $summ = $this->getBasket()->getSumm();
        
        if($this->main->getOrderScoreSumm() > 0){
            $amount = floor($summ / $this->main->getOrderScoreSumm());
            return (int)$amount * $this->main->getOrderScoreVolume();
        }
        
        return 0;
    }

}