<?php
namespace Shop\Services;

use Project\Models\Person\PersonQuery;
use Project\Models\Person\Person;
use Symfony\Component\HttpFoundation\Request;

/**
 * Description of Auth
 *
 * @author Dmitriy
 */
class Auth extends \Diamond\Services\Auth{

    const PERSON_KEY = 'customer_id';

    protected $personCache = [];

    public function __construct(
            \Aura\Auth\AuthFactory $authFactory, 
            \Diamond\Config\Main $mainConf
            ) {
        parent::__construct($authFactory,$mainConf);
    }

    
    public function authCustomer($login, $password, $remeber = false) {

	if(!$User = \Shop\Models\Customer\CustomerQuery::create()
		->filterByEmail($login)
		->filterByPassword($password)
		->findOne()){

	    return false;
	}
        
        $userdata	 = array(
		'customer_name'		=> $User->getName(),
		self::PERSON_KEY        => $User->getId(),
		'customer_email'	=> $User->getEmail()
	    );
        
        $userName = md5(serialize($userdata));

	//авторизующий серсис
	$login_service = $this->authFactory->newLoginService();

	//объект авторизации
	$auth = $this->authFactory->newInstance();


	if($auth->isAnon() || $auth->getUserName() != $userName){
	    
	    $login_service->forceLogin($auth, $userName , $userdata);
	}

        $User
                ->setLastAuth(time())
                ->save()
                ;
        
	return true;
    }

    

    /**
     * Get Auth Person
     * @return boolean|Shop\Models\Customer\Customer
     */
    public function getAuthCustomer(){

	if($auth = $this->getAuth()){
	    
	     $userdata = $auth->getUserData();
	    
	    if(isset($userdata[self::PERSON_KEY])){

		return $this->getPerson($userdata[self::PERSON_KEY]);		
		
	    }
	    
	}

	return false;
    }
    
    /**
     * 
     * @param type $key
     * @return boolean
     */
    protected function getPerson($key)
    {
//        dump($this->personCache);
        if (isset($this->personCache[$key])) {
            return $this->personCache[$key];
        }
        $person = \Shop\Models\Customer\CustomerQuery::create()->setComment("test")->findOneById($key);

        $this->personCache[$key] = $person;
        
        if ( ! $person) {
            return false;
        }

        return $person;
    }

}
