<?php
namespace Shop;

use League\Container\ServiceProvider\AbstractServiceProvider;
use Symfony\Component\HttpFoundation\Session\Session;


/**
 * Description of SystemServiceProvider
 *
 * @author Dmitriy
 */
class ServiceProvider extends AbstractServiceProvider{

    protected $provides = [
	'shop.views_path',
        \Core\Basket\Basket::class,
        "CurrentCustomer"
    ];

    public function register(){
	
	$this->getContainer()->add('CurrentCustomer', function(){
	    return BASEPATH.'/app/views/';
	},true);
        
        $this->getContainer()->add('shop.views_path', function() {
            return __DIR__ . '/../views/';
        });        
        
        $this->getContainer()->add(Session::class,null,true)
        ; 
        
        $this->getContainer()->add(\Shop\Services\Auth::class,null,true)
                ->addArgument($this->getContainer()->get(\Aura\Auth\AuthFactory::class))
                ->addArgument($this->getContainer()->get(\Diamond\Config\Main::class))
                ;
        
        $this->getContainer()->add(\Core\Basket\Basket::class,null,true)
                ->addArgument($this->getContainer()->get(Session::class))
        ;      
        
        $this->getContainer()
            ->inflector(Contracts\ShopCurrentInterface::class)
            ->invokeMethod('setShopByAuthUserService', [Concrete\ShopByAuthUser::class])
        ;
        
    }
}
