<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Propel\Runtime\Collection\ObjectCollection;
use Shop\Models\Shop\Shop as ShopEntity;
use Shop\Models\Shop\ShopQuery;


/**
 * Description of Shop
 *
 * @author Admin
 */
class Shop extends PropelQueryAbstract implements CrudInterface, 
        \Core\Repository\DropdownInreface,
        \Shop\Contracts\ShopCurrentInterface
{
    
    use \Shop\Concrete\ShopAuthUserTrait;

    public function buildQuery(){
        
        $id = $this->curShop ? $this->curShop->getId(): 0;
       
	return ShopQuery ::create()
                ->_if($id > 0)
                    ->filterById($id)
                    ->_or()
                    ->filterByParentId($id)
                ->_endif()
                ;
    }

    public function buildEntity(){
	return new ShopEntity;
    }
    
    /**
     * Получение главного магазина
     * @return ObjectCollection
     */
    public function findOneMain(){
        
        $res = $this->buildQuery()
                ->filterByType("main");

        return $res->findOne();
    }
    
    /**
     * Получение дилеров
     * @return ObjectCollection
     */
    public function findDealers(): ObjectCollection {
        return $this->buildQuery()
                ->findByType("dealer");
    }
    
    /**
     * поиск как дилеров так и ГО
     * @return ObjectCollection
     */
    public function findMainAndDealers($shopKeys = []): ObjectCollection
    {
        return $this->buildQuery()
                ->_if(count($shopKeys))
                    ->filterByPrimaryKeys($shopKeys)
                ->_endif()
                ->useAddressQuery()
                    ->useCityQuery()
                        ->orderByName()
                    ->endUse()
                ->endUse()
                ->findByType(["dealer","main"]);
    }
    
    /**
     * 
     * @param type $id
     * @return ObjectCollection
     */
    public function findStocksByMainId($id): ObjectCollection {
        return $this->buildQuery()
                ->filterByType("stock")
                ->filterByParentId($id)
                //->useParentShopQuery()
                 //   ->filterByType("main")
                //->endUse()
                ->find();
    }
    
    /**
     * 
     * @return array
     */
    public function getDropdownList():array
    {
        return $this->buildQuery()
		->orderByTitle()
		->find()
		->toKeyValue('id','title');
    }

    /**
     * 
     * @return array
     */
    public function getDropdownListWithManagers():array
    {
        return $this->buildQuery()
		->orderByTitle()
                ->useManagerQuery()
                
                ->enduse()
		->find()
		->toKeyValue('id','title');
    }
}
