<?php

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Provider\Provider as ProviderEntity;
use Shop\Models\Provider\ProviderQuery;

/**
 * Description of Bonus
 *
 * @author Dmitriy
 */
class Provider extends PropelQueryAbstract implements CrudInterface, \Shop\Contracts\ShopCurrentInterface, \Core\Repository\DropdownInreface
{
    use \Shop\Concrete\ShopAuthUserTrait;

    public function buildQuery()
    {

        $query = ProviderQuery::create()
                 ->_if($this->curShop)
                        ->filterByShop($this->curShop)
                ->_endif();
                ;
        
        return $query;
    }

    /**
     * 
     * @return PricelistFileEntity
     */
    public function buildEntity()
    {
        return new ProviderEntity;
    }

    public function getDropdownList(){
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }    

}