<?php

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;

use Shop\Models\ProductGroup\ProductGroup as ProductGroupEntity;
use Shop\Models\ProductGroup\ProductGroupQuery;


/**
 * Description of Bonus
 *
 * @author Dmitriy
 */
class ProductGroup extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropdownInreface
{

    public function buildQuery()
    {
        return ProductGroupQuery::create();
    }

    public function buildEntity()
    {
        return new ProductGroupEntity;
    }
    
    public function getDropdownList()
    {
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id', 'name');        
    }


}