<?php

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\PricelistFile\PricelistFile as PricelistFileEntity;
use Shop\Models\PricelistFile\PricelistFileQuery;

/**
 * Description of Bonus
 *
 * @author Dmitriy
 */
class PriceFile extends PropelQueryAbstract implements CrudInterface, \Shop\Contracts\ShopCurrentInterface, 
        \Core\Repository\DropdownInreface
{
    use \Shop\Concrete\ShopAuthUserTrait;

    /**
     * 
     * @return type
     */
    public function buildQuery(){
    
        return PricelistFileQuery::create()
                ->_if($this->curShop)
                    ->useProviderQuery()
                        ->filterByShop($this->curShop)
                    ->endUse()
                ->_endif();
    }
    /**
     * 
     * @return PricelistFileEntity
     */
    public function buildEntity()
    {
        return new PricelistFileEntity;
    }
    
    public function getDropdownList(){
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }     

}