<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\DropdownInreface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Payment\PaymentQuery;
use Shop\Models\Payment\Payment as PaymentEntity;

/**
 * Description of Payment
 *
 * @author Admin
 */
class Payment extends PropelQueryAbstract implements CrudInterface, DropdownInreface
{

    public function buildEntity()
    {
        return new PaymentEntity;
    }

    public function buildQuery()
    {
        return PaymentQuery::create();
    }

    public function getDropdownList(){
	return $this->buildQuery()
		->find()
		->toKeyValue('id','title');
    }

}