<?

namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\PaymentTransaction\PaymentTransactionQuery;
use Shop\Models\PaymentTransaction\PaymentTransaction as PaymentTransactionEntity;

/**
 * Description of Payment
 *
 * @author Admin
 */
class PaymasterTransaction extends PropelQueryAbstract implements CrudInterface
{

    public function buildEntity()
    {
        return new PaymentTransactionEntity;
    }

    public function buildQuery()
    {
        return PaymentTransactionQuery::create();
    }
    
    /**
     * 
     * @param type $id
     * @return type
     */
    public function findByOrderId($id)
    {
        return $this->buildQuery()
                ->filterByOrderId($id)
                ->filterByConfirmed("Y")
                ->findOne();
    }


}