<?php
namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\Domain\Domain as DomainEntity;
use Shop\Models\Domain\DomainQuery;

/**
 * Description of Bonus
 *
 * @author Dmitriy
 */
class Domain extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropdownInreface{

    public function buildQuery(){
	return DomainQuery::create();
    }

    public function buildEntity(){
	return new DomainEntity;
    }
    
    public function getDropdownList(){
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','domain');
    } 
}
