<?php
namespace Shop\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\DropdownInreface;
use Core\Repository\PropelQueryAbstract;
use Shop\Models\CustomerGroup\CustomerGroupQuery;
use Shop\Models\CustomerGroup\CustomerGroup as CustomerGroupEntity;
/**
 * Description of Brand
 *
 * @author Dmitriy
 */
class CustomerGroup extends PropelQueryAbstract implements CrudInterface, DropdownInreface{

    public function buildEntity(){
	return new CustomerGroupEntity;
    }

    public function buildQuery(){
	return CustomerGroupQuery::create();
    }
    
    public function getDropdownList() {
        return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    }

}
