<?

namespace Shop\Modules\MetricWidget;

/**
 * Description of MetricWidget
 *
 * @author Diamond Code Generator
 */
class MetricWidget extends \Core\ModuleController
{

    protected $customerRepo;
    protected $orderRepo;
    protected $productRepo;
    protected $confMain;
    protected $smsService;
    protected $shopService;
            
    function __construct(
                        \Shop\Repositories\Customer $customerRepo, 
                        \Shop\Repositories\Order $orderRepo,
                        \Shop\Repositories\Product $productRepo,
                        \Shop\Config\Main $confMain,
                        \Shop\Services\Sms $smsService,
                        \Shop\Services\Shop $shopService
    )
    {
        $this->customerRepo = $customerRepo;
        $this->orderRepo    = $orderRepo;
        $this->productRepo  = $productRepo;
        $this->confMain     = $confMain;
        $this->smsService   = $smsService;
        $this->shopService  = $shopService;
    }

    public function process()
    {

        $clientsCount = $this->customerRepo->count();

        $clientsCountActive = $this->customerRepo->countActive();

        $ordersCount = $this->orderRepo->count();
        
        $productsCount = $this->productRepo->count();
        
        $ordersSumm = $this
                        ->orderRepo
                        ->summAllOrders($this->confMain->getStateCancel());

        return $this->render([
                    "clientsCount"       => (int) $clientsCount,
                    "clientsCountActive" => (int) $clientsCountActive,
                    "percent"            => $clientsCount?round($clientsCountActive / $clientsCount, 2) * 100:0,
                    "ordersCount"        => $ordersCount,
                    "productsCount"      => $productsCount,
                    "ordersSumm"         => \Shop\Helpers\Price::format($ordersSumm,0),
                    "cur"                => $this->confMain->getCurencyDisplay(),
                    "smsInfo"            => $this->smsService->getBalance()
        ]);
    }

}