<?

namespace Shop\Modules\AdminProviders;

use Core\Registry\Column;
use Core\Registry\Field;

/**
* Description of AdminProviders
*
* @author Diamond Code Generator
*/
class AdminProviders extends \Core\ModuleController{

    protected $providerRepo;
    protected $tableFactory;
    protected $cBuilder;
    protected $currencyRepo;
    protected $shopRepo;
            
    function __construct(\Shop\Repositories\Provider $providerRepo,                         \Shop\Repositories\Shop $shopRepo                       ,
            \Shop\Repositories\Currency $currencyRepo, \Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder)
    {
        $this->providerRepo = $providerRepo;
        $this->tableFactory = $tableFactory;
        $this->cBuilder = $cBuilder;
        $this->currencyRepo = $currencyRepo;
        $this->shopRepo = $shopRepo;
    }    
    
    public function process() {
        
        $table = $this->tableFactory->buildAdminTable("providers", $this->providerRepo);
        $currency = \Diamond\Helpers\Form::prepareDropdown($this->currencyRepo);
        $shops = \Diamond\Helpers\Form::prepareDropdown($this->shopRepo);
        $table
                ->addColumn(
                        new Column("id", "№", 20, false, true)
                        )
                ->addColumn(
                        new Column("name", "Название", 120)
                        )
                ->addColumn(
                        new Column("term", "Срок доставки,дней", 80)
                        )
                //->addColumn(new Column("desc", "Описание", 80))
                ->addColumn(
                        new Column("contact", "Контакты", 80)
                        )
                ->addColumn(
                        new Column("color", "Цвет в поиске", 80)
                        )
                ->addColumn(
                        (new Column("shop_id", "Магазин", 120))
                        ->setFn([$this,"formatShop"])
                        )
                ->addColumn(
                        (new Column("crrency_id", "Валюта", 60))
                        ->setFn([$this,"formatCurrency"])
                        ->setAlign("center")
                        )
                ;
        
         $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputTiny("term"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("crrency_id",$currency),null, "required"
                ))
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("shop_id",$shops),null, "required"
                ))
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildColorPicker("color")
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextArea("contact"),"Контакты"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextArea("desc"),"Описание"
                ))
                 ;
        
        return $table->render();
    }
    
    /**
     * 
     * @param \Shop\Models\Shop\Shop $shop
     */
    public function formatShop(\Shop\Models\Provider\Provider $provider)
    {
        return $provider->getShop()->getTitleWithType();
    }
    
    /**
     * 
     * @param \Shop\Models\Provider\Provider $provider
     */
    public function formatCurrency(\Shop\Models\Provider\Provider $provider)
    {
         return $provider->getCurrency()->getHtmlSign();
    }

}               