<?

namespace Shop\Modules\AdminPriceLists;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminPriceLists
 *
 * @author Diamond Code Generator
 */
class AdminPriceLists extends \Core\ModuleController
{

    protected $pricelistSheetRepo;
    protected $tableFactory;
    protected $cBuilder;
    protected $priceFileRepo;
    protected $curRepo;
                function __construct(\Shop\Repositories\PricelistSheet $pricelistSheetRepo, \Diamond\Factory\Table $tableFactory,
                         \Core\Form\ControlBuilder $cBuilder, \Shop\Repositories\PriceFile $priceFileRepo,
                         \Shop\Repositories\Currency $curRepo)
    {
        $this->pricelistSheetRepo = $pricelistSheetRepo;
        $this->tableFactory       = $tableFactory;
        $this->cBuilder           = $cBuilder;
        $this->priceFileRepo      = $priceFileRepo;
        $this->curRepo = $curRepo;
    }

    public function process()
    {

        $table      = $this->tableFactory->buildAdminTable("pricelistSheet", $this->pricelistSheetRepo);
        $pricefiles = \Diamond\Helpers\Form::prepareDropdown($this->priceFileRepo);
        $currencies = \Diamond\Helpers\Form::prepareDropdown($this->curRepo);
        
        $table
                ->addColumn(
                        new Column("id", "№", 20, false, true)
                )
                ->addColumn(
                        new Column("title", "Прайс-лист", 120)
                )
                ->addColumn(
                        (new Column("count", "Кол-во позиций", 120))->setFn([$this, "formatCount"])
                )
                ->addColumn(
                        (new Column("date_update", "Дата обновления прайса", 100))->setFn([$this, "formatDate"])
                )
                ->addColumn(
                        (new Column("pricelist_file_id", "Прайс-файл", 100))->setFn([$this, "formatPriceListFile"])
                )
                ->addColumn(
                        (new Column("crrency_id", "Валюта прайса", 80))->setFn([$this, "formatCurrency"])
                )
        ;

        if(input_get("id")){
            $pricelist = $this->pricelistSheetRepo->findById(input_get("id"));
            
            $table
                    ->addField(new Field(
                            $this->cBuilder->buildTextLabel("count",$this->formatCount($pricelist))
                            ))
                    ->addField(new Field(
                            $this->cBuilder->buildTextLabel("date_update",$this->formatDate($pricelist))
                            ))
                    ;
        }
        
        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("title"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("pricelist_file_id", $pricefiles), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("crrency_id", $currencies), null, "required"
                ))
        ;
        return $table->render();
    }
    
    public function formatCurrency(\Shop\Models\PricelistSheet\PricelistSheet $price)
    {
        return $price->getCurrency()->getHtmlSign();
    }

    /**
     * 
     * @param \Shop\Models\PricelistSheet\PricelistSheet $priceListSheet
     * @return type
     */
    public function formatCount(\Shop\Models\PricelistSheet\PricelistSheet $priceListSheet)
    {
        return $priceListSheet->getPositions()->count();
    }

    /**
     * 
     * @param \Shop\Models\PricelistSheet\PricelistSheet $priceListSheet
     */
    public function formatDate(\Shop\Models\PricelistSheet\PricelistSheet $priceListSheet)
    {
        return $priceListSheet->getDateUpdate(\Diamond\Helpers\Date::formatDisplay());
    }

    /**
     * 
     * @param \Shop\Models\PricelistSheet\PricelistSheet $priceListSheet
     */
    public function formatPriceListFile(\Shop\Models\PricelistSheet\PricelistSheet $priceListSheet)
    {
        return $priceListSheet->getPricelistFile()->getName();
    }

}