<?

namespace Shop\Modules\AdminPriceFiles;

use Core\Registry\Column;
use Core\Registry\Field;

/**
* Description of AdminPriceFiles
*
* @author Diamond Code Generator
*/
class AdminPriceFiles extends \Core\ModuleController{

    protected $priceFileRepo;
    protected $tableFactory;
    protected $providerRepo;
    protected $cBuilder;
            
    function __construct(\Shop\Repositories\PriceFile $priceFile, \Diamond\Factory\Table $tableFactory, 
            \Shop\Repositories\Provider $providerRepo, \Core\Form\ControlBuilder $cBuilder)
    {
        $this->priceFileRepo = $priceFile;
        $this->tableFactory = $tableFactory;
        $this->providerRepo = $providerRepo;
        $this->cBuilder = $cBuilder;
    }

    /**
     * 
     * @return type
     */
    public function process() {
        
        $table = $this->tableFactory->buildAdminTable("price-files", $this->priceFileRepo);


        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("name", "Название файла", 120))
                ->addColumn((new Column("provider_id", "Поставщик", 120))->setFn([$this,"formatProvider"]))
                ;
        
        $providers = \Diamond\Helpers\Form::prepareDropdown($this->providerRepo);
        
         $table
                 
                 ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInput("name"), null, "required","например: price.csv"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("provider_id",$providers),null, "required"
                ))
                 ;
         
        return $table->render();
    }
    
    /**
     * 
     * @param \Shop\Models\PricelistFile\PricelistFile $priceFile
     * @return type
     */
    public function formatProvider(\Shop\Models\PricelistFile\PricelistFile $priceFile)
    {
        return $priceFile->getProvider()->getName();
    }

}               