<?

namespace Shop\Modules\AdminPositions;

use Core\Registry\Column;
use Core\Registry\Field;

/**
* Description of AdminPositions
*
* @author Diamond Code Generator
*/
class AdminPositions extends \Core\ModuleController{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $mainConf;
    protected $priceRepo;
    protected $saleRepo;
    protected $productRepo;
    protected $shopRepo;
            
    function __construct(
            \Diamond\Factory\Table $tableFactory, 
            \Core\Form\ControlBuilder $cBuilder, 
            \Shop\Repositories\Position $repo,
            \Shop\Config\Main $mainConf,
            \Shop\Repositories\PricelistSheet $priceRepo,
            \Shop\Repositories\Sale $saleRepo,
            \Shop\Repositories\Product $productRepo,
            \Shop\Repositories\Shop $shopRepo
    )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->mainConf = $mainConf;
        $this->priceRepo = $priceRepo;
        $this->saleRepo = $saleRepo;
        $this->productRepo = $productRepo;
        $this->shopRepo = $shopRepo;
    }    
    
    public function process() {
        
        $table = $this->tableFactory->buildAdminTable("positions", $this->repo->setSelectFilter([$this,"sortedById"]));
        $pricelists = \Diamond\Helpers\Form::prepareDropdown($this->priceRepo);
        $sales = \Diamond\Helpers\Form::prepareDropdownWithDef($this->saleRepo,-1);
        $products = \Diamond\Helpers\Form::prepareDropdown($this->productRepo);
        //$shops = \Diamond\Helpers\Form::prepareDropdown($this->shopRepo);
        $table
                ->getGrid()
                ->setSortname("id")
                ->setSortorder("DESC")
                ;
        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn(new Column("desc", "Описание", 120))
                ->addColumn((new Column("remain", "Наличие", 60))->setAlign("right"))
                ->addColumn((new Column("price", "Цена", 60))->setAlign("right"))
                ->addColumn((new Column("old_price", "Старая цена", 60))->setAlign("right"))
                ->addColumn((new Column("sale_id", "Тип скидки", 60))->setFn([$this, "formatSale"]))
                ->addColumn((new Column("product_id", "Товар", 80))->setFn([$this, "formatProduct"]))
                ->addColumn(new Column("image", "Изображение", 60))
                //->addColumn((new Column("shop_id", "Офис/т.точка", 140))->setFn([$this, "formatShop"]))
                ->addColumn((new Column("pricelist_sheet_id", "Прайс-лист", 140))->setFn([$this, "formatPriceList"]))
//                ->addColumn((new Column("type", "Тип точки", 120))->setFn([$this, "formatParent"]))
        ;
        
        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("price"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("old_price")
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputSmall("remain"), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("pricelist_sheet_id", $pricelists), null, "required"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("sale_id", $sales)
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildAutoDropdown("product_id", $products)
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildTextArea("desc"),null,null
                ))

        ;
        
        return $table->render();
    }
    
    /**
     * 
     * @param \Shop\Models\PaymentTransaction\PaymentTransactionQuery $query
     * @return type
     */
    public function sortedById(\Shop\Models\Position\PositionQuery $query) {
        return $query->orderById(\Propel\Runtime\ActiveQuery\Criteria::DESC);
    }
    
    /**
     * 
     * @param \Shop\Models\Position\Position $position
     * @return string
     */
    public function formatProduct(\Shop\Models\Position\Position $position)
    {
        return $position->getProduct()->getTitle();
    }
    
     public function formatPriceList(\Shop\Models\Position\Position $position)
    {
        return $position->getPricelistSheet()->getTitle();
    }
    
    /**
     * 
     * @param \Shop\Models\Position\Position $position
     * @return string
     */
    public function formatShop(\Shop\Models\Position\Position $position)
    {
        return $position->getPricelistSheet()->getPricelistFile()->getProvider()->getShop()->getTitleWithType();
    }    
    /**
     * 
     * @param \Shop\Models\Position\Position $position
     * @return string
     */
    public function formatSale(\Shop\Models\Position\Position $position)
    {
        return $position->getSaleId();
    } 
}               