<?

namespace Shop\Modules\AdminComplexRates;

use Core\Registry\Column;
use Core\Registry\Field;

/**
 * Description of AdminComplexRates
 * @todo добавить город страну регион
 * @author Diamond Code Generator
 */
class AdminComplexRates extends \Core\ModuleController
{

    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $brandRepo;
    protected $groupRepo;
    protected $customerRepo;
    protected $shopRepo;
    protected $pricelistSheetRepo;

    function __construct(\Diamond\Factory\Table $tableFactory, \Core\Form\ControlBuilder $cBuilder,
                         \Shop\Repositories\ComplexRate $repo, \Shop\Repositories\Brand $brandRepo,
                         \Shop\Repositories\CustomerGroup $groupRepo, \Shop\Repositories\Customer $customerRepo,
                         \Shop\Repositories\Shop $shopRepo, \Shop\Repositories\PricelistSheet $pricelistSheetRepo
    )
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->brandRepo = $brandRepo;
        $this->customerRepo = $customerRepo;
        $this->groupRepo = $groupRepo;
        $this->shopRepo = $shopRepo;
        $this->pricelistSheetRepo = $pricelistSheetRepo;
    }

    public function process()
    {

        $table = $this->tableFactory->buildAdminTable("complex_rates", $this->repo);

        $table
                ->addColumn(new Column("id", "№", 20, false, true))
                ->addColumn((new Column("brand_id", "Производитель", 120))->setFn($this, "formatBrand"))
                ->addColumn((new Column("customer_group_id", "Группа клиента", 120))->setFn($this, "formatGroup"))
                ->addColumn((new Column("customer_id", "Клиент", 120))->setFn($this, "formatCustomer"))
                ->addColumn((new Column("shop_id", "Офис", 90))->setFn($this, "formatShop"))
                ->addColumn((new Column("shop_id", "Офис", 90))->setFn($this, "formatShop"))
                ->addColumn((new Column("pricelist_sheet_id", "Прайс-лист", 90))->setFn($this, "formatPriceList"))
                ->addColumn((new Column("rate", "Скидка/Наценка,%", 120))->setFn($this, "formatRate"))
                ->addColumn(new Column("priority", "Приоритет", 80))
        ;

        $brands = \Shop\Helpers\Form::prepareDropdownWithDef($this->brandRepo,"%");
        $groups = \Shop\Helpers\Form::prepareDropdownWithDef($this->groupRepo,"%");
        $customers = \Shop\Helpers\Form::prepareDropdownWithDef($this->customerRepo,"%");
        $shops = \Shop\Helpers\Form::prepareDropdownWithDef($this->shopRepo,"%");
        $prices = \Shop\Helpers\Form::prepareDropdownWithDef($this->pricelistSheetRepo,"%");

        $pri = [];
        for($pr=0;$pr<=100;$pr++){
            $pri []= $pr;
        }
        
        $table
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildInputLittle("rate"), null, "required", "пример: 15.5% -наценка, -20.5% -скидка"
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("brand_id", $brands)
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("customer_group_id", $groups)
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("customer_id", $customers)
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("shop_id", $shops)
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("pricelist_sheet_id", $prices)
                ))
                ->addField(
                        new Field(
                        $this->cBuilder
                        ->buildDropdownUniform("priority", $pri)
                ))               
        ;

        return $table->render();
    }

    /**
     * 
     * @param \Shop\Models\ComplexRate\ComplexRate $rate
     * @return type
     */
    public function formatPriceList(\Shop\Models\ComplexRate\ComplexRate $rate)
    {
        if ($rate->getPricelistSheetId() > 0 && $list = $this->pricelistSheetRepo->findById($rate->getPricelistSheetId())) {
            return $list->getTitle();
        }

        return $rate->getPricelistSheetId();        
    }
    
    /**
     * 
     * @param \Shop\Models\ComplexRate\ComplexRate $rate
     */
    public function formatBrand(\Shop\Models\ComplexRate\ComplexRate $rate)
    {
        if ($rate->getBrandId() > 0 && $brand = $this->brandRepo->findById($rate->getBrandId())) {
            return $brand->getName();
        }

        return $rate->getBrandId();
    }

    /**
     * 
     * @param \Shop\Models\ComplexRate\ComplexRate $rate
     */
    public function formatGroup(\Shop\Models\ComplexRate\ComplexRate $rate)
    {
        if ($rate->getCustomerGroupId() > 0 && $group = $this->groupRepo->findById($rate->getCustomerGroupId())) {
            return $group->getName();
        }


        return $rate->getCustomerGroupId();
    }

    /**
     * 
     * @param \Shop\Models\ComplexRate\ComplexRate $rate
     */
    public function formatCustomer(\Shop\Models\ComplexRate\ComplexRate $rate)
    {
        if ($rate->getCustomerId() > 0 && $customer = $this->customerRepo->findById($rate->getCustomerId())) {
            return $customer->getName();
        }

        return $rate->getCustomerId();
    }

    /**
     * 
     * @param \Shop\Models\ComplexRate\ComplexRate $rate
     */
    public function formatShop(\Shop\Models\ComplexRate\ComplexRate $rate)
    {
        if ($rate->getShopId() > 0 && $shop = $this->shopRepo->findById($rate->getShopId())) {
            return $shop->getTitle();
        }

        return $rate->getShopId();
    }

    /**
     * 
     * @param \Shop\Models\ComplexRate\ComplexRate $rate
     */
    public function formatRate(\Shop\Models\ComplexRate\ComplexRate $rate)
    {
        return $rate->getRate();
    }

}