<?php

namespace Shop\Modules\AdminCategories;

use Shop\Repositories\Category;
use Core\Form\ControlBuilder;
use Core\Registry\Factory\RepoRegistry;
use Core\Registry\Column;
use Core\Registry\Control;
use Core\Registry\Field;
use Core\Form\Control as ControlForm;

/**
 * Description of AdminCategories
 *
 * @author Dmitriy
 */
class AdminCategories extends \Core\ModuleController
{

    protected $controlBuilder;
    protected $categoryRepo;
    
    protected $tableFactory;
                function __construct(Category $categoryRepo, ControlBuilder $controlBuilder, 
            \Diamond\Factory\Table $tableFactory)
    {

        $this->tableFactory = $tableFactory;
        $this->categoryRepo = $categoryRepo;
        $this->controlBuilder = $controlBuilder;
    }

    public function process()
    {
        
        $registry = $this->tableFactory->buildAdminTable("categories", $this->categoryRepo);

        $registry->setColumns([
            new Column("id", "№", 20, false, true),
            (new Column("parent", "Родитель", 60))->setFn(function(\Shop\Models\Category\Category $category) {
                        if (is_object($category->getParentCategory())) {
                            return $category->getParentCategory()->getTitle();
                        }
                    }),
            new Column("title", "Наименование", 70),
            new Column("alias", "Псевдоним", 70),
            
            new Column("image", "Изображение", 60),
            (new Column("Desc", "Описание", 70))->setFn(function(\Shop\Models\Category\Category $cat){
                return \Shop\Helpers\Text::clearText($cat->getDesc());
            })
        ]);

        $registry
                ->addField(
                        new Field(
                        $this->controlBuilder
                        ->buildInput("title"), 'Наименование', "required"
                ))
                ->addField(
                        new Field(
                        $this->controlBuilder
                        ->buildInput("alias"), 'Псевдоним', "required", "для использования в ЧПУ"
                ))
                ->addField(
                        new Field($this->controlBuilder->buildDropdownUniform("parent_id",
                                                                              \Shop\Helpers\Form::prepareDropdown($this->categoryRepo,
                                                                                                                  "родительский раздел",
                                                                                                                  "getDropdownListAllWithParent")),
                                                                                                                  "Родительский раздел")
                )
                ->addField(
                        new Field(
                        $this->controlBuilder
                        ->buildTextEditor("desc")
                        ->setHeight(200)
                        ->setCompact(true), 'Описание', NULL,
                                     "Подробное описание раздела"
                ))
        ;


        return $registry->render();
    }

}