<?php

namespace Shop\Models\ShopProductGroupsRel\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Product\Product;
use Shop\Models\ProductGroup\ProductGroup;
use Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel as ChildShopProductGroupsRel;
use Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery as ChildShopProductGroupsRelQuery;
use Shop\Models\ShopProductGroupsRel\Map\ShopProductGroupsRelTableMap;

/**
 * Base class that represents a query for the 'shop_product_groups_rel' table.
 *
 *
 *
 * @method     ChildShopProductGroupsRelQuery orderByProductId($order = Criteria::ASC) Order by the product_id column
 * @method     ChildShopProductGroupsRelQuery orderByGroupId($order = Criteria::ASC) Order by the group_id column
 *
 * @method     ChildShopProductGroupsRelQuery groupByProductId() Group by the product_id column
 * @method     ChildShopProductGroupsRelQuery groupByGroupId() Group by the group_id column
 *
 * @method     ChildShopProductGroupsRelQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildShopProductGroupsRelQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildShopProductGroupsRelQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildShopProductGroupsRelQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildShopProductGroupsRelQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildShopProductGroupsRelQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildShopProductGroupsRelQuery leftJoinProduct($relationAlias = null) Adds a LEFT JOIN clause to the query using the Product relation
 * @method     ChildShopProductGroupsRelQuery rightJoinProduct($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Product relation
 * @method     ChildShopProductGroupsRelQuery innerJoinProduct($relationAlias = null) Adds a INNER JOIN clause to the query using the Product relation
 *
 * @method     ChildShopProductGroupsRelQuery joinWithProduct($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Product relation
 *
 * @method     ChildShopProductGroupsRelQuery leftJoinWithProduct() Adds a LEFT JOIN clause and with to the query using the Product relation
 * @method     ChildShopProductGroupsRelQuery rightJoinWithProduct() Adds a RIGHT JOIN clause and with to the query using the Product relation
 * @method     ChildShopProductGroupsRelQuery innerJoinWithProduct() Adds a INNER JOIN clause and with to the query using the Product relation
 *
 * @method     ChildShopProductGroupsRelQuery leftJoinProductGroup($relationAlias = null) Adds a LEFT JOIN clause to the query using the ProductGroup relation
 * @method     ChildShopProductGroupsRelQuery rightJoinProductGroup($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ProductGroup relation
 * @method     ChildShopProductGroupsRelQuery innerJoinProductGroup($relationAlias = null) Adds a INNER JOIN clause to the query using the ProductGroup relation
 *
 * @method     ChildShopProductGroupsRelQuery joinWithProductGroup($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ProductGroup relation
 *
 * @method     ChildShopProductGroupsRelQuery leftJoinWithProductGroup() Adds a LEFT JOIN clause and with to the query using the ProductGroup relation
 * @method     ChildShopProductGroupsRelQuery rightJoinWithProductGroup() Adds a RIGHT JOIN clause and with to the query using the ProductGroup relation
 * @method     ChildShopProductGroupsRelQuery innerJoinWithProductGroup() Adds a INNER JOIN clause and with to the query using the ProductGroup relation
 *
 * @method     \Shop\Models\Product\ProductQuery|\Shop\Models\ProductGroup\ProductGroupQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildShopProductGroupsRel findOne(ConnectionInterface $con = null) Return the first ChildShopProductGroupsRel matching the query
 * @method     ChildShopProductGroupsRel findOneOrCreate(ConnectionInterface $con = null) Return the first ChildShopProductGroupsRel matching the query, or a new ChildShopProductGroupsRel object populated from the query conditions when no match is found
 *
 * @method     ChildShopProductGroupsRel findOneByProductId(int $product_id) Return the first ChildShopProductGroupsRel filtered by the product_id column
 * @method     ChildShopProductGroupsRel findOneByGroupId(int $group_id) Return the first ChildShopProductGroupsRel filtered by the group_id column *

 * @method     ChildShopProductGroupsRel requirePk($key, ConnectionInterface $con = null) Return the ChildShopProductGroupsRel by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProductGroupsRel requireOne(ConnectionInterface $con = null) Return the first ChildShopProductGroupsRel matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopProductGroupsRel requireOneByProductId(int $product_id) Return the first ChildShopProductGroupsRel filtered by the product_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopProductGroupsRel requireOneByGroupId(int $group_id) Return the first ChildShopProductGroupsRel filtered by the group_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopProductGroupsRel[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildShopProductGroupsRel objects based on current ModelCriteria
 * @method     ChildShopProductGroupsRel[]|ObjectCollection findByProductId(int $product_id) Return ChildShopProductGroupsRel objects filtered by the product_id column
 * @method     ChildShopProductGroupsRel[]|ObjectCollection findByGroupId(int $group_id) Return ChildShopProductGroupsRel objects filtered by the group_id column
 * @method     ChildShopProductGroupsRel[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ShopProductGroupsRelQuery extends ModelCriteria
{

    // data_cache behavior

    protected $cacheKey      = '';
    protected $cacheLocale   = '';
    protected $cacheEnable   = true;
    protected $cacheLifeTime = 3600;
            protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\ShopProductGroupsRel\Base\ShopProductGroupsRelQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\ShopProductGroupsRel\\ShopProductGroupsRel', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildShopProductGroupsRelQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildShopProductGroupsRelQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildShopProductGroupsRelQuery) {
            return $criteria;
        }
        $query = new ChildShopProductGroupsRelQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array[$product_id, $group_id] $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildShopProductGroupsRel|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopProductGroupsRelTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ShopProductGroupsRelTableMap::getInstanceFromPool(serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]))))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->filterByPrimaryKey($key)->findOne($con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopProductGroupsRel A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `product_id`, `group_id` FROM `shop_product_groups_rel` WHERE `product_id` = :p0 AND `group_id` = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildShopProductGroupsRel $obj */
            $obj = new ChildShopProductGroupsRel();
            $obj->hydrate($row);
            ShopProductGroupsRelTableMap::addInstanceToPool($obj, serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildShopProductGroupsRel|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(ShopProductGroupsRelTableMap::COL_PRODUCT_ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(ShopProductGroupsRelTableMap::COL_GROUP_ID, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(ShopProductGroupsRelTableMap::COL_PRODUCT_ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(ShopProductGroupsRelTableMap::COL_GROUP_ID, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the product_id column
     *
     * Example usage:
     * <code>
     * $query->filterByProductId(1234); // WHERE product_id = 1234
     * $query->filterByProductId(array(12, 34)); // WHERE product_id IN (12, 34)
     * $query->filterByProductId(array('min' => 12)); // WHERE product_id > 12
     * </code>
     *
     * @see       filterByProduct()
     *
     * @param     mixed $productId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function filterByProductId($productId = null, $comparison = null)
    {
        if (is_array($productId)) {
            $useMinMax = false;
            if (isset($productId['min'])) {
                $this->addUsingAlias(ShopProductGroupsRelTableMap::COL_PRODUCT_ID, $productId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($productId['max'])) {
                $this->addUsingAlias(ShopProductGroupsRelTableMap::COL_PRODUCT_ID, $productId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopProductGroupsRelTableMap::COL_PRODUCT_ID, $productId, $comparison);
    }

    /**
     * Filter the query on the group_id column
     *
     * Example usage:
     * <code>
     * $query->filterByGroupId(1234); // WHERE group_id = 1234
     * $query->filterByGroupId(array(12, 34)); // WHERE group_id IN (12, 34)
     * $query->filterByGroupId(array('min' => 12)); // WHERE group_id > 12
     * </code>
     *
     * @see       filterByProductGroup()
     *
     * @param     mixed $groupId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function filterByGroupId($groupId = null, $comparison = null)
    {
        if (is_array($groupId)) {
            $useMinMax = false;
            if (isset($groupId['min'])) {
                $this->addUsingAlias(ShopProductGroupsRelTableMap::COL_GROUP_ID, $groupId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($groupId['max'])) {
                $this->addUsingAlias(ShopProductGroupsRelTableMap::COL_GROUP_ID, $groupId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopProductGroupsRelTableMap::COL_GROUP_ID, $groupId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Product\Product object
     *
     * @param \Shop\Models\Product\Product|ObjectCollection $product The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function filterByProduct($product, $comparison = null)
    {
        if ($product instanceof \Shop\Models\Product\Product) {
            return $this
                ->addUsingAlias(ShopProductGroupsRelTableMap::COL_PRODUCT_ID, $product->getId(), $comparison);
        } elseif ($product instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ShopProductGroupsRelTableMap::COL_PRODUCT_ID, $product->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProduct() only accepts arguments of type \Shop\Models\Product\Product or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Product relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function joinProduct($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Product');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Product');
        }

        return $this;
    }

    /**
     * Use the Product relation Product object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Product\ProductQuery A secondary query class using the current class as primary query
     */
    public function useProductQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProduct($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Product', '\Shop\Models\Product\ProductQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\ProductGroup\ProductGroup object
     *
     * @param \Shop\Models\ProductGroup\ProductGroup|ObjectCollection $productGroup The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function filterByProductGroup($productGroup, $comparison = null)
    {
        if ($productGroup instanceof \Shop\Models\ProductGroup\ProductGroup) {
            return $this
                ->addUsingAlias(ShopProductGroupsRelTableMap::COL_GROUP_ID, $productGroup->getId(), $comparison);
        } elseif ($productGroup instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(ShopProductGroupsRelTableMap::COL_GROUP_ID, $productGroup->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProductGroup() only accepts arguments of type \Shop\Models\ProductGroup\ProductGroup or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ProductGroup relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function joinProductGroup($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ProductGroup');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ProductGroup');
        }

        return $this;
    }

    /**
     * Use the ProductGroup relation ProductGroup object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\ProductGroup\ProductGroupQuery A secondary query class using the current class as primary query
     */
    public function useProductGroupQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProductGroup($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ProductGroup', '\Shop\Models\ProductGroup\ProductGroupQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildShopProductGroupsRel $shopProductGroupsRel Object to remove from the list of results
     *
     * @return $this|ChildShopProductGroupsRelQuery The current query, for fluid interface
     */
    public function prune($shopProductGroupsRel = null)
    {
        if ($shopProductGroupsRel) {
            $this->addCond('pruneCond0', $this->getAliasedColName(ShopProductGroupsRelTableMap::COL_PRODUCT_ID), $shopProductGroupsRel->getProductId(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(ShopProductGroupsRelTableMap::COL_GROUP_ID), $shopProductGroupsRel->getGroupId(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

    /**
     * Code to execute after every DELETE statement
     *
     * @param     int $affectedRows the number of deleted rows
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePostDelete($affectedRows, ConnectionInterface $con)
    {
        // data_cache behavior
        \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery::purgeCache();

        return $this->postDelete($affectedRows, $con);
    }

    /**
     * Code to execute after every UPDATE statement
     *
     * @param     int $affectedRows the number of updated rows
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePostUpdate($affectedRows, ConnectionInterface $con)
    {
        // data_cache behavior
        \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery::purgeCache();

        return $this->postUpdate($affectedRows, $con);
    }

    /**
     * Deletes all rows from the shop_product_groups_rel table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopProductGroupsRelTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ShopProductGroupsRelTableMap::clearInstancePool();
            ShopProductGroupsRelTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopProductGroupsRelTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ShopProductGroupsRelTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ShopProductGroupsRelTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ShopProductGroupsRelTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // data_cache behavior

    public static function purgeCache()
    {

        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace(ShopProductGroupsRelTableMap::TABLE_NAME);

        return $driver->deleteAll();

    }

    public static function cacheFetch($key)
    {

        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace(ShopProductGroupsRelTableMap::TABLE_NAME);

        $result = $driver->fetch($key);

        if ($result !== null) {
            if ($result instanceof \ArrayAccess) {
                foreach ($result as $element) {
                    if ($element instanceof \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel) {
                        ShopProductGroupsRelTableMap::addInstanceToPool($element);
                    }
                }
            } else if ($result instanceof \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel) {
                ShopProductGroupsRelTableMap::addInstanceToPool($result);
            }
        }

        return $result;


    }

    public static function cacheStore($key, $data, $lifetime)
    {
        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace(ShopProductGroupsRelTableMap::TABLE_NAME);

        return $driver->save($key,$data,$lifetime);
    }

    public static function cacheDelete($key)
    {
        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace(ShopProductGroupsRelTableMap::TABLE_NAME);

        return $driver->delete($key);
    }

    public function setCacheEnable()
    {
        $this->cacheEnable = true;

        return $this;
    }

    public function setCacheDisable()
    {
        $this->cacheEnable = false;

        return $this;
    }

    public function isCacheEnable()
    {
        return (bool)$this->cacheEnable;
    }

    public function getCacheKey()
    {
        if ($this->cacheKey) {
            return $this->cacheKey;
        }
        $params      = array();
        $sql_hash    = hash('md4', $this->createSelectSql($params));
        $params_hash = hash('md4', json_encode($params));
        $locale      = $this->cacheLocale ? '_' . $this->cacheLocale : '';
        $this->cacheKey = $sql_hash . '_' . $params_hash . $locale;

        return $this->cacheKey;
    }

    public function setCacheKey($cacheKey)
    {
        $this->cacheKey = $cacheKey;

        return $this;
    }

    public function setCacheLocale($locale)
    {
        $this->cacheLocale = $locale;

        return $this;
    }

    public function setLifeTime($lifetime)
    {
        $this->cacheLifeTime = $lifetime;

        return $this;
    }

    public function getLifeTime()
    {
        return $this->cacheLifeTime;
    }

    /**
     * Issue a SELECT query based on the current ModelCriteria
     * and format the list of results with the current formatter
     * By default, returns an array of model objects
     *
     * @param ConnectionInterface $con an optional connection object
     *
     * @return \Propel\Runtime\Collection\ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function find(ConnectionInterface $con = null)
    {
        if ($this->isCacheEnable() && $cache = \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery::cacheFetch($this->getCacheKey())) {
            if ($cache instanceof \Propel\Runtime\Collection\ObjectCollection) {
                $formatter = $this->getFormatter()->init($this);
                $cache->setFormatter($formatter);
            }
            return $cache;
        }

        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }

        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria->doSelect($con);

        $data = $criteria->getFormatter()->init($criteria)->format($dataFetcher);

        if ($this->isCacheEnable()) {
            \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery::cacheStore($this->getCacheKey(), $data, $this->getLifeTime());
        }

        return $data;


    }

    /**
     * Issue a SELECT ... LIMIT 1 query based on the current ModelCriteria
     * and format the result with the current formatter
     * By default, returns a model object
     *
     * @param ConnectionInterface $con an optional connection object
     *
     * @return mixed the result, formatted by the current formatter
     */
    public function findOne(ConnectionInterface $con  = null)
    {
        if ($this->isCacheEnable() && $cache = \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery::cacheFetch($this->getCacheKey())) {
            if ($cache instanceof \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel) {
                return $cache;
            }
        }

        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }

        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $criteria->limit(1);
        $dataFetcher = $criteria->doSelect($con);

        $data = $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);

        if ($this->isCacheEnable()) {
            \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery::cacheStore($this->getCacheKey(), $data, $this->getLifeTime());
        }

        return $data;
    }

} // ShopProductGroupsRelQuery
