<?php

namespace Shop\Models\Shop\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Models\Manager\Map\ManagerTableMap;
use Shop\Models\Shop\Shop;
use Shop\Models\Shop\ShopQuery;


/**
 * This class defines the structure of the 'shop_shops' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 */
class ShopTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Shop.Map.ShopTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'shop_shops';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Shop\\Models\\Shop\\Shop';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Shop.Shop';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 12;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 12;

    /**
     * the column name for the id field
     */
    const COL_ID = 'shop_shops.id';

    /**
     * the column name for the title field
     */
    const COL_TITLE = 'shop_shops.title';

    /**
     * the column name for the desc field
     */
    const COL_DESC = 'shop_shops.desc';

    /**
     * the column name for the image field
     */
    const COL_IMAGE = 'shop_shops.image';

    /**
     * the column name for the logo field
     */
    const COL_LOGO = 'shop_shops.logo';

    /**
     * the column name for the director_contact field
     */
    const COL_DIRECTOR_CONTACT = 'shop_shops.director_contact';

    /**
     * the column name for the phones field
     */
    const COL_PHONES = 'shop_shops.phones';

    /**
     * the column name for the emails field
     */
    const COL_EMAILS = 'shop_shops.emails';

    /**
     * the column name for the type field
     */
    const COL_TYPE = 'shop_shops.type';

    /**
     * the column name for the address_id field
     */
    const COL_ADDRESS_ID = 'shop_shops.address_id';

    /**
     * the column name for the parent_id field
     */
    const COL_PARENT_ID = 'shop_shops.parent_id';

    /**
     * the column name for the domain_id field
     */
    const COL_DOMAIN_ID = 'shop_shops.domain_id';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Title', 'Desc', 'Image', 'Logo', 'directorContact', 'Phones', 'emails', 'Type', 'AddressId', 'ParentId', 'DomainId', ),
        self::TYPE_CAMELNAME     => array('id', 'title', 'desc', 'image', 'logo', 'directorContact', 'phones', 'emails', 'type', 'addressId', 'parentId', 'domainId', ),
        self::TYPE_COLNAME       => array(ShopTableMap::COL_ID, ShopTableMap::COL_TITLE, ShopTableMap::COL_DESC, ShopTableMap::COL_IMAGE, ShopTableMap::COL_LOGO, ShopTableMap::COL_DIRECTOR_CONTACT, ShopTableMap::COL_PHONES, ShopTableMap::COL_EMAILS, ShopTableMap::COL_TYPE, ShopTableMap::COL_ADDRESS_ID, ShopTableMap::COL_PARENT_ID, ShopTableMap::COL_DOMAIN_ID, ),
        self::TYPE_FIELDNAME     => array('id', 'title', 'desc', 'image', 'logo', 'director_contact', 'phones', 'emails', 'type', 'address_id', 'parent_id', 'domain_id', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Title' => 1, 'Desc' => 2, 'Image' => 3, 'Logo' => 4, 'directorContact' => 5, 'Phones' => 6, 'emails' => 7, 'Type' => 8, 'AddressId' => 9, 'ParentId' => 10, 'DomainId' => 11, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'title' => 1, 'desc' => 2, 'image' => 3, 'logo' => 4, 'directorContact' => 5, 'phones' => 6, 'emails' => 7, 'type' => 8, 'addressId' => 9, 'parentId' => 10, 'domainId' => 11, ),
        self::TYPE_COLNAME       => array(ShopTableMap::COL_ID => 0, ShopTableMap::COL_TITLE => 1, ShopTableMap::COL_DESC => 2, ShopTableMap::COL_IMAGE => 3, ShopTableMap::COL_LOGO => 4, ShopTableMap::COL_DIRECTOR_CONTACT => 5, ShopTableMap::COL_PHONES => 6, ShopTableMap::COL_EMAILS => 7, ShopTableMap::COL_TYPE => 8, ShopTableMap::COL_ADDRESS_ID => 9, ShopTableMap::COL_PARENT_ID => 10, ShopTableMap::COL_DOMAIN_ID => 11, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'title' => 1, 'desc' => 2, 'image' => 3, 'logo' => 4, 'director_contact' => 5, 'phones' => 6, 'emails' => 7, 'type' => 8, 'address_id' => 9, 'parent_id' => 10, 'domain_id' => 11, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('shop_shops');
        $this->setPhpName('Shop');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Models\\Shop\\Shop');
        $this->setPackage('Models.Shop');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', true, 255, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addColumn('image', 'Image', 'VARCHAR', false, 255, null);
        $this->addColumn('logo', 'Logo', 'VARCHAR', false, 255, null);
        $this->addColumn('director_contact', 'directorContact', 'LONGVARCHAR', false, null, null);
        $this->addColumn('phones', 'Phones', 'LONGVARCHAR', false, null, null);
        $this->addColumn('emails', 'emails', 'LONGVARCHAR', false, null, null);
        $this->addColumn('type', 'Type', 'CHAR', true, null, 'main');
        $this->addForeignKey('address_id', 'AddressId', 'INTEGER', 'shop_addresses', 'id', true, null, null);
        $this->addForeignKey('parent_id', 'ParentId', 'INTEGER', 'shop_shops', 'id', false, null, null);
        $this->addForeignKey('domain_id', 'DomainId', 'INTEGER', '_domains', 'id', false, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Address', '\\Shop\\Models\\Address\\Address', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':address_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('ParentShop', '\\Shop\\Models\\Shop\\Shop', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':parent_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Domain', '\\Diamond\\Models\\Domain\\Domain', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':domain_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('ShopRelatedById', '\\Shop\\Models\\Shop\\Shop', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':parent_id',
    1 => ':id',
  ),
), null, null, 'ShopsRelatedById', false);
        $this->addRelation('Manager', '\\Shop\\Models\\Manager\\Manager', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':shop_id',
    1 => ':id',
  ),
), 'CASCADE', null, 'Managers', false);
        $this->addRelation('Order', '\\Shop\\Models\\Order\\Order', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':shop_id',
    1 => ':id',
  ),
), null, null, 'Orders', false);
        $this->addRelation('Provider', '\\Shop\\Models\\Provider\\Provider', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':shop_id',
    1 => ':id',
  ),
), null, null, 'Providers', false);
    } // buildRelations()

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array Associative array (name => parameters) of behaviors
     */
    public function getBehaviors()
    {
        return array(
            'archivable' => array('archive_table' => '', 'archive_phpname' => '', 'archive_class' => '', 'log_archived_at' => 'true', 'archived_at_column' => 'archived_at', 'archive_on_insert' => 'false', 'archive_on_update' => 'false', 'archive_on_delete' => 'true', ),
            'data_cache' => array('backend' => 'memcache', 'lifetime' => '3600', 'auto_cache' => 'true', ),
        );
    } // getBehaviors()
    /**
     * Method to invalidate the instance pool of all tables related to shop_shops     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in related instance pools,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        ManagerTableMap::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? ShopTableMap::CLASS_DEFAULT : ShopTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (Shop object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = ShopTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ShopTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ShopTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ShopTableMap::OM_CLASS;
            /** @var Shop $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ShopTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ShopTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ShopTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Shop $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ShopTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ShopTableMap::COL_ID);
            $criteria->addSelectColumn(ShopTableMap::COL_TITLE);
            $criteria->addSelectColumn(ShopTableMap::COL_DESC);
            $criteria->addSelectColumn(ShopTableMap::COL_IMAGE);
            $criteria->addSelectColumn(ShopTableMap::COL_LOGO);
            $criteria->addSelectColumn(ShopTableMap::COL_DIRECTOR_CONTACT);
            $criteria->addSelectColumn(ShopTableMap::COL_PHONES);
            $criteria->addSelectColumn(ShopTableMap::COL_EMAILS);
            $criteria->addSelectColumn(ShopTableMap::COL_TYPE);
            $criteria->addSelectColumn(ShopTableMap::COL_ADDRESS_ID);
            $criteria->addSelectColumn(ShopTableMap::COL_PARENT_ID);
            $criteria->addSelectColumn(ShopTableMap::COL_DOMAIN_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.image');
            $criteria->addSelectColumn($alias . '.logo');
            $criteria->addSelectColumn($alias . '.director_contact');
            $criteria->addSelectColumn($alias . '.phones');
            $criteria->addSelectColumn($alias . '.emails');
            $criteria->addSelectColumn($alias . '.type');
            $criteria->addSelectColumn($alias . '.address_id');
            $criteria->addSelectColumn($alias . '.parent_id');
            $criteria->addSelectColumn($alias . '.domain_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(ShopTableMap::DATABASE_NAME)->getTable(ShopTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(ShopTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(ShopTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new ShopTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a Shop or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or Shop object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Models\Shop\Shop) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ShopTableMap::DATABASE_NAME);
            $criteria->add(ShopTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ShopQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ShopTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ShopTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_shops table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return ShopQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Shop or Criteria object.
     *
     * @param mixed               $criteria Criteria or Shop object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Shop object
        }

        if ($criteria->containsKey(ShopTableMap::COL_ID) && $criteria->keyContainsValue(ShopTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.ShopTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = ShopQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // ShopTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
ShopTableMap::buildTableMap();
