<?php

namespace Shop\Models\ProductGroup\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\ProductGroup\ProductGroup as ChildProductGroup;
use Shop\Models\ProductGroup\ProductGroupQuery as ChildProductGroupQuery;
use Shop\Models\ProductGroup\Map\ProductGroupTableMap;
use Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel;

/**
 * Base class that represents a query for the 'shop_product_groups' table.
 *
 *
 *
 * @method     ChildProductGroupQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildProductGroupQuery orderByname($order = Criteria::ASC) Order by the name column
 *
 * @method     ChildProductGroupQuery groupById() Group by the id column
 * @method     ChildProductGroupQuery groupByname() Group by the name column
 *
 * @method     ChildProductGroupQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildProductGroupQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildProductGroupQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildProductGroupQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildProductGroupQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildProductGroupQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildProductGroupQuery leftJoinShopProductGroupsRel($relationAlias = null) Adds a LEFT JOIN clause to the query using the ShopProductGroupsRel relation
 * @method     ChildProductGroupQuery rightJoinShopProductGroupsRel($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ShopProductGroupsRel relation
 * @method     ChildProductGroupQuery innerJoinShopProductGroupsRel($relationAlias = null) Adds a INNER JOIN clause to the query using the ShopProductGroupsRel relation
 *
 * @method     ChildProductGroupQuery joinWithShopProductGroupsRel($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ShopProductGroupsRel relation
 *
 * @method     ChildProductGroupQuery leftJoinWithShopProductGroupsRel() Adds a LEFT JOIN clause and with to the query using the ShopProductGroupsRel relation
 * @method     ChildProductGroupQuery rightJoinWithShopProductGroupsRel() Adds a RIGHT JOIN clause and with to the query using the ShopProductGroupsRel relation
 * @method     ChildProductGroupQuery innerJoinWithShopProductGroupsRel() Adds a INNER JOIN clause and with to the query using the ShopProductGroupsRel relation
 *
 * @method     \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildProductGroup findOne(ConnectionInterface $con = null) Return the first ChildProductGroup matching the query
 * @method     ChildProductGroup findOneOrCreate(ConnectionInterface $con = null) Return the first ChildProductGroup matching the query, or a new ChildProductGroup object populated from the query conditions when no match is found
 *
 * @method     ChildProductGroup findOneById(int $id) Return the first ChildProductGroup filtered by the id column
 * @method     ChildProductGroup findOneByname(string $name) Return the first ChildProductGroup filtered by the name column *

 * @method     ChildProductGroup requirePk($key, ConnectionInterface $con = null) Return the ChildProductGroup by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProductGroup requireOne(ConnectionInterface $con = null) Return the first ChildProductGroup matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProductGroup requireOneById(int $id) Return the first ChildProductGroup filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildProductGroup requireOneByname(string $name) Return the first ChildProductGroup filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildProductGroup[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildProductGroup objects based on current ModelCriteria
 * @method     ChildProductGroup[]|ObjectCollection findById(int $id) Return ChildProductGroup objects filtered by the id column
 * @method     ChildProductGroup[]|ObjectCollection findByname(string $name) Return ChildProductGroup objects filtered by the name column
 * @method     ChildProductGroup[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ProductGroupQuery extends ModelCriteria
{

    // data_cache behavior

    protected $cacheKey      = '';
    protected $cacheLocale   = '';
    protected $cacheEnable   = true;
    protected $cacheLifeTime = 3600;
            protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\ProductGroup\Base\ProductGroupQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\ProductGroup\\ProductGroup', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildProductGroupQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildProductGroupQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildProductGroupQuery) {
            return $criteria;
        }
        $query = new ChildProductGroupQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildProductGroup|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ProductGroupTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ProductGroupTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->filterByPrimaryKey($key)->findOne($con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildProductGroup A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name` FROM `shop_product_groups` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildProductGroup $obj */
            $obj = new ChildProductGroup();
            $obj->hydrate($row);
            ProductGroupTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildProductGroup|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildProductGroupQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ProductGroupTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildProductGroupQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ProductGroupTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductGroupQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ProductGroupTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ProductGroupTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductGroupTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByname('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByname('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildProductGroupQuery The current query, for fluid interface
     */
    public function filterByname($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ProductGroupTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel object
     *
     * @param \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel|ObjectCollection $shopProductGroupsRel the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProductGroupQuery The current query, for fluid interface
     */
    public function filterByShopProductGroupsRel($shopProductGroupsRel, $comparison = null)
    {
        if ($shopProductGroupsRel instanceof \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel) {
            return $this
                ->addUsingAlias(ProductGroupTableMap::COL_ID, $shopProductGroupsRel->getGroupId(), $comparison);
        } elseif ($shopProductGroupsRel instanceof ObjectCollection) {
            return $this
                ->useShopProductGroupsRelQuery()
                ->filterByPrimaryKeys($shopProductGroupsRel->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByShopProductGroupsRel() only accepts arguments of type \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRel or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ShopProductGroupsRel relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildProductGroupQuery The current query, for fluid interface
     */
    public function joinShopProductGroupsRel($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ShopProductGroupsRel');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ShopProductGroupsRel');
        }

        return $this;
    }

    /**
     * Use the ShopProductGroupsRel relation ShopProductGroupsRel object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery A secondary query class using the current class as primary query
     */
    public function useShopProductGroupsRelQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinShopProductGroupsRel($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ShopProductGroupsRel', '\Shop\Models\ShopProductGroupsRel\ShopProductGroupsRelQuery');
    }

    /**
     * Filter the query by a related Product object
     * using the shop_product_groups_rel table as cross reference
     *
     * @param Product $product the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildProductGroupQuery The current query, for fluid interface
     */
    public function filterByProduct($product, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useShopProductGroupsRelQuery()
            ->filterByProduct($product, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ChildProductGroup $productGroup Object to remove from the list of results
     *
     * @return $this|ChildProductGroupQuery The current query, for fluid interface
     */
    public function prune($productGroup = null)
    {
        if ($productGroup) {
            $this->addUsingAlias(ProductGroupTableMap::COL_ID, $productGroup->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Code to execute after every DELETE statement
     *
     * @param     int $affectedRows the number of deleted rows
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePostDelete($affectedRows, ConnectionInterface $con)
    {
        // data_cache behavior
        \Shop\Models\ProductGroup\ProductGroupQuery::purgeCache();

        return $this->postDelete($affectedRows, $con);
    }

    /**
     * Code to execute after every UPDATE statement
     *
     * @param     int $affectedRows the number of updated rows
     * @param     ConnectionInterface $con The connection object used by the query
     */
    protected function basePostUpdate($affectedRows, ConnectionInterface $con)
    {
        // data_cache behavior
        \Shop\Models\ProductGroup\ProductGroupQuery::purgeCache();

        return $this->postUpdate($affectedRows, $con);
    }

    /**
     * Deletes all rows from the shop_product_groups table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductGroupTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ProductGroupTableMap::clearInstancePool();
            ProductGroupTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductGroupTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ProductGroupTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ProductGroupTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ProductGroupTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    // data_cache behavior

    public static function purgeCache()
    {

        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace(ProductGroupTableMap::TABLE_NAME);

        return $driver->deleteAll();

    }

    public static function cacheFetch($key)
    {

        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace(ProductGroupTableMap::TABLE_NAME);

        $result = $driver->fetch($key);

        if ($result !== null) {
            if ($result instanceof \ArrayAccess) {
                foreach ($result as $element) {
                    if ($element instanceof \Shop\Models\ProductGroup\ProductGroup) {
                        ProductGroupTableMap::addInstanceToPool($element);
                    }
                }
            } else if ($result instanceof \Shop\Models\ProductGroup\ProductGroup) {
                ProductGroupTableMap::addInstanceToPool($result);
            }
        }

        return $result;


    }

    public static function cacheStore($key, $data, $lifetime)
    {
        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace(ProductGroupTableMap::TABLE_NAME);

        return $driver->save($key,$data,$lifetime);
    }

    public static function cacheDelete($key)
    {
        $driver = \TFC\Cache\DoctrineCacheFactory::factory('memcache');
        $driver->setNamespace(ProductGroupTableMap::TABLE_NAME);

        return $driver->delete($key);
    }

    public function setCacheEnable()
    {
        $this->cacheEnable = true;

        return $this;
    }

    public function setCacheDisable()
    {
        $this->cacheEnable = false;

        return $this;
    }

    public function isCacheEnable()
    {
        return (bool)$this->cacheEnable;
    }

    public function getCacheKey()
    {
        if ($this->cacheKey) {
            return $this->cacheKey;
        }
        $params      = array();
        $sql_hash    = hash('md4', $this->createSelectSql($params));
        $params_hash = hash('md4', json_encode($params));
        $locale      = $this->cacheLocale ? '_' . $this->cacheLocale : '';
        $this->cacheKey = $sql_hash . '_' . $params_hash . $locale;

        return $this->cacheKey;
    }

    public function setCacheKey($cacheKey)
    {
        $this->cacheKey = $cacheKey;

        return $this;
    }

    public function setCacheLocale($locale)
    {
        $this->cacheLocale = $locale;

        return $this;
    }

    public function setLifeTime($lifetime)
    {
        $this->cacheLifeTime = $lifetime;

        return $this;
    }

    public function getLifeTime()
    {
        return $this->cacheLifeTime;
    }

    /**
     * Issue a SELECT query based on the current ModelCriteria
     * and format the list of results with the current formatter
     * By default, returns an array of model objects
     *
     * @param ConnectionInterface $con an optional connection object
     *
     * @return \Propel\Runtime\Collection\ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function find(ConnectionInterface $con = null)
    {
        if ($this->isCacheEnable() && $cache = \Shop\Models\ProductGroup\ProductGroupQuery::cacheFetch($this->getCacheKey())) {
            if ($cache instanceof \Propel\Runtime\Collection\ObjectCollection) {
                $formatter = $this->getFormatter()->init($this);
                $cache->setFormatter($formatter);
            }
            return $cache;
        }

        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }

        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria->doSelect($con);

        $data = $criteria->getFormatter()->init($criteria)->format($dataFetcher);

        if ($this->isCacheEnable()) {
            \Shop\Models\ProductGroup\ProductGroupQuery::cacheStore($this->getCacheKey(), $data, $this->getLifeTime());
        }

        return $data;


    }

    /**
     * Issue a SELECT ... LIMIT 1 query based on the current ModelCriteria
     * and format the result with the current formatter
     * By default, returns a model object
     *
     * @param ConnectionInterface $con an optional connection object
     *
     * @return mixed the result, formatted by the current formatter
     */
    public function findOne(ConnectionInterface $con  = null)
    {
        if ($this->isCacheEnable() && $cache = \Shop\Models\ProductGroup\ProductGroupQuery::cacheFetch($this->getCacheKey())) {
            if ($cache instanceof \Shop\Models\ProductGroup\ProductGroup) {
                return $cache;
            }
        }

        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }

        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $criteria->limit(1);
        $dataFetcher = $criteria->doSelect($con);

        $data = $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);

        if ($this->isCacheEnable()) {
            \Shop\Models\ProductGroup\ProductGroupQuery::cacheStore($this->getCacheKey(), $data, $this->getLifeTime());
        }

        return $data;
    }

} // ProductGroupQuery
