<?php

namespace Shop\Models\Product\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Models\Position\Map\PositionTableMap;
use Shop\Models\Product\Product;
use Shop\Models\Product\ProductQuery;


/**
 * This class defines the structure of the 'shop_products' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 */
class ProductTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Product.Map.ProductTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'shop_products';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Shop\\Models\\Product\\Product';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Product.Product';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 21;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 21;

    /**
     * the column name for the id field
     */
    const COL_ID = 'shop_products.id';

    /**
     * the column name for the title field
     */
    const COL_TITLE = 'shop_products.title';

    /**
     * the column name for the desc field
     */
    const COL_DESC = 'shop_products.desc';

    /**
     * the column name for the short_desc field
     */
    const COL_SHORT_DESC = 'shop_products.short_desc';

    /**
     * the column name for the article field
     */
    const COL_ARTICLE = 'shop_products.article';

    /**
     * the column name for the price field
     */
    const COL_PRICE = 'shop_products.price';

    /**
     * the column name for the img field
     */
    const COL_IMG = 'shop_products.img';

    /**
     * the column name for the special field
     */
    const COL_SPECIAL = 'shop_products.special';

    /**
     * the column name for the active field
     */
    const COL_ACTIVE = 'shop_products.active';

    /**
     * the column name for the mt_title field
     */
    const COL_MT_TITLE = 'shop_products.mt_title';

    /**
     * the column name for the mt_description field
     */
    const COL_MT_DESCRIPTION = 'shop_products.mt_description';

    /**
     * the column name for the mt_keywords field
     */
    const COL_MT_KEYWORDS = 'shop_products.mt_keywords';

    /**
     * the column name for the remains field
     */
    const COL_REMAINS = 'shop_products.remains';

    /**
     * the column name for the udate field
     */
    const COL_UDATE = 'shop_products.udate';

    /**
     * the column name for the cdate field
     */
    const COL_CDATE = 'shop_products.cdate';

    /**
     * the column name for the pdate field
     */
    const COL_PDATE = 'shop_products.pdate';

    /**
     * the column name for the ref field
     */
    const COL_REF = 'shop_products.ref';

    /**
     * the column name for the min_quality field
     */
    const COL_MIN_QUALITY = 'shop_products.min_quality';

    /**
     * the column name for the seazon field
     */
    const COL_SEAZON = 'shop_products.seazon';

    /**
     * the column name for the category_id field
     */
    const COL_CATEGORY_ID = 'shop_products.category_id';

    /**
     * the column name for the brand_id field
     */
    const COL_BRAND_ID = 'shop_products.brand_id';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Title', 'Desc', 'ShortDesc', 'Article', 'Price', 'Img', 'Special', 'Active', 'MtTitle', 'MtDescription', 'MtKeywords', 'Remains', 'dateUpdate', 'dateCreate', 'datePublic', 'Ref', 'MinQualitye', 'Seazon', 'CategoryId', 'BrandId', ),
        self::TYPE_CAMELNAME     => array('id', 'title', 'desc', 'shortDesc', 'article', 'price', 'img', 'special', 'active', 'mtTitle', 'mtDescription', 'mtKeywords', 'remains', 'dateUpdate', 'dateCreate', 'datePublic', 'ref', 'minQualitye', 'seazon', 'categoryId', 'brandId', ),
        self::TYPE_COLNAME       => array(ProductTableMap::COL_ID, ProductTableMap::COL_TITLE, ProductTableMap::COL_DESC, ProductTableMap::COL_SHORT_DESC, ProductTableMap::COL_ARTICLE, ProductTableMap::COL_PRICE, ProductTableMap::COL_IMG, ProductTableMap::COL_SPECIAL, ProductTableMap::COL_ACTIVE, ProductTableMap::COL_MT_TITLE, ProductTableMap::COL_MT_DESCRIPTION, ProductTableMap::COL_MT_KEYWORDS, ProductTableMap::COL_REMAINS, ProductTableMap::COL_UDATE, ProductTableMap::COL_CDATE, ProductTableMap::COL_PDATE, ProductTableMap::COL_REF, ProductTableMap::COL_MIN_QUALITY, ProductTableMap::COL_SEAZON, ProductTableMap::COL_CATEGORY_ID, ProductTableMap::COL_BRAND_ID, ),
        self::TYPE_FIELDNAME     => array('id', 'title', 'desc', 'short_desc', 'article', 'price', 'img', 'special', 'active', 'mt_title', 'mt_description', 'mt_keywords', 'remains', 'udate', 'cdate', 'pdate', 'ref', 'min_quality', 'seazon', 'category_id', 'brand_id', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Title' => 1, 'Desc' => 2, 'ShortDesc' => 3, 'Article' => 4, 'Price' => 5, 'Img' => 6, 'Special' => 7, 'Active' => 8, 'MtTitle' => 9, 'MtDescription' => 10, 'MtKeywords' => 11, 'Remains' => 12, 'dateUpdate' => 13, 'dateCreate' => 14, 'datePublic' => 15, 'Ref' => 16, 'MinQualitye' => 17, 'Seazon' => 18, 'CategoryId' => 19, 'BrandId' => 20, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'title' => 1, 'desc' => 2, 'shortDesc' => 3, 'article' => 4, 'price' => 5, 'img' => 6, 'special' => 7, 'active' => 8, 'mtTitle' => 9, 'mtDescription' => 10, 'mtKeywords' => 11, 'remains' => 12, 'dateUpdate' => 13, 'dateCreate' => 14, 'datePublic' => 15, 'ref' => 16, 'minQualitye' => 17, 'seazon' => 18, 'categoryId' => 19, 'brandId' => 20, ),
        self::TYPE_COLNAME       => array(ProductTableMap::COL_ID => 0, ProductTableMap::COL_TITLE => 1, ProductTableMap::COL_DESC => 2, ProductTableMap::COL_SHORT_DESC => 3, ProductTableMap::COL_ARTICLE => 4, ProductTableMap::COL_PRICE => 5, ProductTableMap::COL_IMG => 6, ProductTableMap::COL_SPECIAL => 7, ProductTableMap::COL_ACTIVE => 8, ProductTableMap::COL_MT_TITLE => 9, ProductTableMap::COL_MT_DESCRIPTION => 10, ProductTableMap::COL_MT_KEYWORDS => 11, ProductTableMap::COL_REMAINS => 12, ProductTableMap::COL_UDATE => 13, ProductTableMap::COL_CDATE => 14, ProductTableMap::COL_PDATE => 15, ProductTableMap::COL_REF => 16, ProductTableMap::COL_MIN_QUALITY => 17, ProductTableMap::COL_SEAZON => 18, ProductTableMap::COL_CATEGORY_ID => 19, ProductTableMap::COL_BRAND_ID => 20, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'title' => 1, 'desc' => 2, 'short_desc' => 3, 'article' => 4, 'price' => 5, 'img' => 6, 'special' => 7, 'active' => 8, 'mt_title' => 9, 'mt_description' => 10, 'mt_keywords' => 11, 'remains' => 12, 'udate' => 13, 'cdate' => 14, 'pdate' => 15, 'ref' => 16, 'min_quality' => 17, 'seazon' => 18, 'category_id' => 19, 'brand_id' => 20, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('shop_products');
        $this->setPhpName('Product');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Models\\Product\\Product');
        $this->setPackage('Models.Product');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', true, 255, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addColumn('short_desc', 'ShortDesc', 'VARCHAR', false, 255, null);
        $this->addColumn('article', 'Article', 'VARCHAR', false, 120, null);
        $this->addColumn('price', 'Price', 'DECIMAL', false, 19, 0);
        $this->addColumn('img', 'Img', 'VARCHAR', false, 255, null);
        $this->addColumn('special', 'Special', 'CHAR', true, null, 'N');
        $this->addColumn('active', 'Active', 'CHAR', true, null, 'Y');
        $this->addColumn('mt_title', 'MtTitle', 'VARCHAR', false, 255, null);
        $this->addColumn('mt_description', 'MtDescription', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_keywords', 'MtKeywords', 'LONGVARCHAR', false, null, null);
        $this->addColumn('remains', 'Remains', 'CHAR', false, 5, null);
        $this->addColumn('udate', 'dateUpdate', 'TIMESTAMP', false, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('cdate', 'dateCreate', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('pdate', 'datePublic', 'TIMESTAMP', false, null, null);
        $this->addColumn('ref', 'Ref', 'INTEGER', false, null, null);
        $this->addColumn('min_quality', 'MinQualitye', 'VARCHAR', false, 10, null);
        $this->addColumn('seazon', 'Seazon', 'VARCHAR', false, 50, null);
        $this->addForeignKey('category_id', 'CategoryId', 'INTEGER', 'shop_categories', 'id', true, null, null);
        $this->addForeignKey('brand_id', 'BrandId', 'INTEGER', 'shop_brands', 'id', true, null, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Category', '\\Shop\\Models\\Category\\Category', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Brand', '\\Shop\\Models\\Brand\\Brand', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':brand_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('ShopProductGroupsRel', '\\Shop\\Models\\ShopProductGroupsRel\\ShopProductGroupsRel', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), null, null, 'ShopProductGroupsRels', false);
        $this->addRelation('Position', '\\Shop\\Models\\Position\\Position', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), 'CASCADE', null, 'Positions', false);
        $this->addRelation('ProductHitSale', '\\Shop\\Models\\ProductHitSale\\ProductHitSale', RelationMap::ONE_TO_ONE, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('ProductSuperPrice', '\\Shop\\Models\\ProductSuperPrice\\ProductSuperPrice', RelationMap::ONE_TO_ONE, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('ProductGroup', '\\Shop\\Models\\ProductGroup\\ProductGroup', RelationMap::MANY_TO_MANY, array(), null, null, 'ProductGroups');
    } // buildRelations()
    /**
     * Method to invalidate the instance pool of all tables related to shop_products     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in related instance pools,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        PositionTableMap::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? ProductTableMap::CLASS_DEFAULT : ProductTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (Product object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = ProductTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ProductTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ProductTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ProductTableMap::OM_CLASS;
            /** @var Product $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ProductTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ProductTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ProductTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Product $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ProductTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ProductTableMap::COL_ID);
            $criteria->addSelectColumn(ProductTableMap::COL_TITLE);
            $criteria->addSelectColumn(ProductTableMap::COL_DESC);
            $criteria->addSelectColumn(ProductTableMap::COL_SHORT_DESC);
            $criteria->addSelectColumn(ProductTableMap::COL_ARTICLE);
            $criteria->addSelectColumn(ProductTableMap::COL_PRICE);
            $criteria->addSelectColumn(ProductTableMap::COL_IMG);
            $criteria->addSelectColumn(ProductTableMap::COL_SPECIAL);
            $criteria->addSelectColumn(ProductTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(ProductTableMap::COL_MT_TITLE);
            $criteria->addSelectColumn(ProductTableMap::COL_MT_DESCRIPTION);
            $criteria->addSelectColumn(ProductTableMap::COL_MT_KEYWORDS);
            $criteria->addSelectColumn(ProductTableMap::COL_REMAINS);
            $criteria->addSelectColumn(ProductTableMap::COL_UDATE);
            $criteria->addSelectColumn(ProductTableMap::COL_CDATE);
            $criteria->addSelectColumn(ProductTableMap::COL_PDATE);
            $criteria->addSelectColumn(ProductTableMap::COL_REF);
            $criteria->addSelectColumn(ProductTableMap::COL_MIN_QUALITY);
            $criteria->addSelectColumn(ProductTableMap::COL_SEAZON);
            $criteria->addSelectColumn(ProductTableMap::COL_CATEGORY_ID);
            $criteria->addSelectColumn(ProductTableMap::COL_BRAND_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.short_desc');
            $criteria->addSelectColumn($alias . '.article');
            $criteria->addSelectColumn($alias . '.price');
            $criteria->addSelectColumn($alias . '.img');
            $criteria->addSelectColumn($alias . '.special');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.mt_title');
            $criteria->addSelectColumn($alias . '.mt_description');
            $criteria->addSelectColumn($alias . '.mt_keywords');
            $criteria->addSelectColumn($alias . '.remains');
            $criteria->addSelectColumn($alias . '.udate');
            $criteria->addSelectColumn($alias . '.cdate');
            $criteria->addSelectColumn($alias . '.pdate');
            $criteria->addSelectColumn($alias . '.ref');
            $criteria->addSelectColumn($alias . '.min_quality');
            $criteria->addSelectColumn($alias . '.seazon');
            $criteria->addSelectColumn($alias . '.category_id');
            $criteria->addSelectColumn($alias . '.brand_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(ProductTableMap::DATABASE_NAME)->getTable(ProductTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(ProductTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(ProductTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new ProductTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a Product or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or Product object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Models\Product\Product) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ProductTableMap::DATABASE_NAME);
            $criteria->add(ProductTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ProductQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ProductTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ProductTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_products table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return ProductQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Product or Criteria object.
     *
     * @param mixed               $criteria Criteria or Product object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Product object
        }


        // Set the correct dbName
        $query = ProductQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // ProductTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
ProductTableMap::buildTableMap();
