<?php

namespace Shop\Models\Customer;

use Shop\Models\Customer\Base\Customer as BaseCustomer;

/**
 * Skeleton subclass for representing a row from the 'shop_customer' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Customer extends BaseCustomer implements \Shop\Contracts\CustomerComplexInterface, 
        \Shop\Contracts\CustomerAccessPricesInterface
{

    /**
     * Код созданный при регистрации
     * @var type 
     */
    protected $registerCode;
    
    protected $access = false;


    /**
     * Доступ к прайс-листам клиента
     * @todo Удалить костыль перевести на настройки
     * @return type
     */
    public function getAccessPriceListScheetIds():array
    {

        if($this->access !== false){
            return $this->access;
        }
        
        $access = \Shop\Models\PriceAccess\PriceAccessQuery::create()
                ->addAnd("", sprintf("'%s' LIKE `customer_group_id`", $this->getGroupId()) , \Propel\Runtime\ActiveQuery\Criteria::CUSTOM)
                ->addAnd("", sprintf("'%s' LIKE `shop_id`", $this->getManager()->getShopId()) , \Propel\Runtime\ActiveQuery\Criteria::CUSTOM)
                ->addAnd("", sprintf("'%s' LIKE `customer_id`", $this->getId()) , \Propel\Runtime\ActiveQuery\Criteria::CUSTOM)
                 ->orderBy("customer_id",\Propel\Runtime\ActiveQuery\Criteria::DESC)
                ->orderBy("customer_group_id",\Propel\Runtime\ActiveQuery\Criteria::DESC)
                ->orderBy("shop_id",\Propel\Runtime\ActiveQuery\Criteria::DESC)
               
                ;
        
        
        $row =  $access->findOne();
        
        if(empty($row->getPriceScheetId())){
            return [];
        }

        $this->access = (array)$row->getPriceScheetId();
        
        return (array)$row->getPriceScheetId();
        
//        dump($row);
//        exit("test");
//        if($this->getGroupId()==$confMain->getgroupOptovic() && $this->getManager()->getShopId()==$confMain->getshopNN()){
//            return (array)$row["price_scheet_id"];
//        }
//        elseif($this->getGroupId()==$confMain->getgroupOptovic()){
//            return [2];
//        }
//        elseif($this->getGroupId()==$confMain->getGroupRetail()){
//            return [1];
//        }
//        else{
//            return [22];
//        }
        
    }
    
    /**
     * 
     * @return string
     */
    function getRegisterCode(): string {
        return $this->registerCode;
    }

    /**
     * 
     * @param string $registerCode
     * @return $this
     */
    function setRegisterCode(string $registerCode) {
        $this->registerCode = $registerCode;
        return $this;
    }
    
    /**
     * Разрешена ли отправка на email
     * @return bool
     */
    public function isNotifyEmail():bool{
        
        if(strpos($this->getNotifyType(), "email")!==false){
            return true;
        }
        
        return false;
    }
    
    /**
     * Разрешена ли отправка на sms
     * @return bool
     */
    public function isNotifySms():bool{
        
        if(strpos($this->getNotifyType(), "sms")!==false){
            return true;
        }
        
        return false;
    }    

    /**
     * Полный адресс
     * @return type
     */
    public function getFullAddress(): string
    {

        $city = $this->getCustomerCity();
        $region = $city->getCityRegion();
        
        return sprintf(
                "%s, г.%s", 
                $region->getName(), 
                $city->getName()
        );
    }    
}
